/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.openeuler.sun.security.ec.ECKeyFactory;
import org.openeuler.util.GMUtil;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class ECDHKeyAgreementAdaptor
extends KeyAgreementSpi {
    private static final Debug debug = Debug.getInstance("jca", "KeyAgreement");
    private KeyAgreement keyAgreement;

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        ECPrivateKey privateKey = (ECPrivateKey)ECKeyFactory.toECKey(key);
        this.keyAgreement = ECDHKeyAgreementAdaptor.getKeyAgreement(privateKey.getParams());
        this.keyAgreement.init(key, random);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        return this.keyAgreement.doPhase(key, lastPhase);
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.keyAgreement.generateSecret();
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        return this.keyAgreement.generateSecret(sharedSecret, offset);
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return this.keyAgreement.generateSecret(algorithm);
    }

    private static KeyAgreement getKeyAgreement(AlgorithmParameterSpec params) throws InvalidKeyException {
        KeyAgreement keyAgreement;
        try {
            keyAgreement = GMUtil.isSM2Curve(params) ? KeyAgreement.getInstance("SM2DH") : ECDHKeyAgreementAdaptor.getECDHKeyAgreement();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e);
        }
        return keyAgreement;
    }

    private static KeyAgreement getECDHKeyAgreement() throws NoSuchAlgorithmException {
        String algorithm = "ECDH";
        KeyAgreement instance = null;
        List<Provider.Service> services = GetInstance.getServices("KeyAgreement", algorithm);
        for (Provider.Service s : services) {
            block3: {
                String providerName = s.getProvider().getName();
                if (providerName.equals("BGMJCEProvider") || providerName.equals("BGMProvider")) continue;
                try {
                    instance = KeyAgreement.getInstance(algorithm, s.getProvider());
                }
                catch (NoSuchAlgorithmException e) {
                    if (debug == null) break block3;
                    debug.println(e.getMessage());
                }
            }
            if (instance == null) continue;
            return instance;
        }
        throw new NoSuchAlgorithmException("Algorithm " + algorithm + " not available");
    }
}

