/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.spec.AlgorithmParameterSpec;
import org.openeuler.org.bouncycastle.SM2ParameterSpec;
import org.openeuler.util.ConfigUtil;

public class SM2Util {
    private static final String BC_SM2PARAMETERSPEC_CLASS = "org.bouncycastle.jcajce.spec.SM2ParameterSpec";
    private static Constructor<?> BC_SM2PARAMETERSPEC_CONSTRUCTOR;

    private static void init() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = Class.forName(BC_SM2PARAMETERSPEC_CLASS);
        BC_SM2PARAMETERSPEC_CONSTRUCTOR = clazz.getConstructor(byte[].class);
    }

    private static AlgorithmParameterSpec createBCSM2ParameterSpec(byte[] idBytes) {
        if (BC_SM2PARAMETERSPEC_CONSTRUCTOR == null) {
            return null;
        }
        try {
            return (AlgorithmParameterSpec)BC_SM2PARAMETERSPEC_CONSTRUCTOR.newInstance(new Object[]{idBytes});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static AlgorithmParameterSpec createSM2ParameterSpec(byte[] idBytes) {
        return ConfigUtil.useLegacyJCE() ? SM2Util.createBCSM2ParameterSpec(idBytes) : new SM2ParameterSpec(idBytes);
    }

    static {
        try {
            SM2Util.init();
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }
}

