/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import sun.security.util.Debug;

public class ConfigUtil {
    private static final Debug debug = Debug.getInstance("provider");
    private static final Properties config = new Properties();
    private static boolean useLegacyJCE = false;

    private ConfigUtil() {
    }

    private static void initConfig() {
        block17: {
            String path = System.getSecurityManager() != null ? System.getProperty("bgmprovider.conf") : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("bgmprovider.conf");
                }
            });
            if (debug != null) {
                debug.println("bgmprovider.conf: " + path);
            }
            if (path == null) {
                return;
            }
            File file = new File(path);
            if (!file.exists()) {
                return;
            }
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                config.load(inputStream);
            }
            catch (IOException e) {
                if (debug == null) break block17;
                debug.println(e.getMessage());
            }
        }
    }

    public static boolean enable(String key) {
        return ConfigUtil.enable(key, "true");
    }

    public static boolean enable(final String key, String defaultValue) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        if (debug != null) {
            debug.println("System.getProperty(\"" + key + "\")=" + value);
        }
        if (value == null) {
            value = (String)config.getOrDefault((Object)key, defaultValue);
            if (debug != null) {
                debug.println("config.getOrDefault(\"" + key + "\",\"" + defaultValue + "\")=" + value);
            }
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean useLegacyJCE() {
        return useLegacyJCE;
    }

    static {
        ConfigUtil.initConfig();
        useLegacyJCE = ConfigUtil.enable("jce.useLegacy", "false");
    }
}

