/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.rm.support.measurement;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SimpleUCUMValidator {
    public static final String[] ATOMSYMBOL_VALUES = new String[]{"m", "s", "g", "rad", "K", "C", "cd", "10*", "10^", "[pi]", "%", "[ppth]", "[ppm]", "[ppb]", "[pptr]", "mol", "sr", "Hz", "N", "Pa", "J", "W", "A", "V", "F", "Ohm", "S", "Wb", "Cel", "T", "H", "lm", "lx", "Bq", "Gy", "Sv", "gon", "deg", "'", "''", "l", "L", "ar", "min", "h", "d", "a_t", "a_j", "a_g", "a", "wk", "mo_s", "mo_j", "mo_g", "mo", "t", "bar", "u", "eV", "AU", "pc", "[c]", "[h]", "[k]", "[eps_0]", "[mu_0]", "[e]", "[m_e]", "[m_p]", "[G]", "[g]", "atm", "[ly]", "gf", "[lbf_av]", "Ky", "Gal", "dyn", "erg", "P", "Bi", "St", "Mx", "G", "Oe", "Gb", "sb", "Lmb", "ph", "Ci", "R", "RAD", "REM", "[in_i]", "[ft_i]", "[yd_i]", "[mi_i]", "[fth_i]", "[nmi_i]", "[kn_i]", "[sin_i]", "[sft_i]", "[syd_i]", "[cin_i]", "[cft_i]", "[cyd_i]", "[bf_i]", "[cr_i]", "[mil_i]", "[cml_i]", "[hd_i]", "[ft_us]", "[yd_us]", "[in_us]", "[rd_us]", "[ch_us]", "[lk_us]", "[rch_us]", "[rlk_us]", "[fth_us]", "[fur_us]", "[mi_us]", "[acr_us]", "[srd_us]", "[smi_us]", "[sct]", "[twp]", "[mil_us]", "[in_br]", "[ft_br]", "[rd_br]", "[ch_br]", "[lk_br]", "[fth_br]", "[pc_br]", "[yd_br]", "[mi_br]", "[nmi_br]", "[kn_br]", "[acr_br]", "[gal_us]", "[bbl_us]", "[qt_us]", "[pt_us]", "[gil_us]", "[foz_us]", "[fdr_us]", "[min_us]", "[crd_us]", "[bu_us]", "[gal_wi]", "[pk_us]", "[dqt_us]", "[dpt_us]", "[tbs_us]", "[tsp_us]", "[cup_us]", "[foz_m]", "[cup_m]", "[tsp_m]", "[tbs_m]", "[gal_br]", "[pk_br]", "[bu_br]", "[qt_br]", "[pt_br]", "[gil_br]", "[foz_br]", "[fdr_br]", "[min_br]", "[gr]", "[lb_av]", "[oz_av]", "[dr_av]", "[scwt_av]", "[lcwt_av]", "[ston_av]", "[lton_av]", "[stone_av]", "[pwt_tr]", "[oz_tr]", "[lb_tr]", "[sc_ap]", "[dr_ap]", "[oz_ap]", "[lb_ap]", "[oz_m]", "[lne]", "[pnt]", "[pca]", "[pnt_pr]", "[pca_pr]", "[pied]", "[pouce]", "[ligne]", "[didot]", "[cicero]", "[degF]", "[degR]", "[degRe]", "cal_[15]", "cal_[20]", "cal_m", "cal_IT", "cal_th", "cal", "[Cal]", "[Btu_39]", "[Btu_59]", "[Btu_60]", "[Btu_m]", "[Btu_IT]", "[Btu_th]", "[Btu]", "[HP]", "tex", "[den]", "m[H2O]", "m[Hg]", "[in_i'H2O]", "[in_i'Hg]", "[PRU]", "[wood'U]", "[diop]", "[p'diop]", "%[slope]", "[mesh_i]", "[Ch]", "[drp]", "[hnsf'U]", "[MET]", "[hp'_X]", "[hp'_C]", "[hp'_M]", "[hp'_Q]", "[hp_X]", "[hp_C]", "[hp_M]", "[hp_Q]", "[kp_X]", "[kp_C]", "[kp_M]", "[kp_Q]", "eq", "osm", "[pH]", "g%", "[S]", "[HPF]", "[LPF]", "kat", "U", "[iU]", "[IU]", "[arb'U]", "[USP'U]", "[GPL'U]", "[MPL'U]", "[APL'U]", "[beth'U]", "[anti'Xa'U]", "[todd'U]", "[dye'U]", "[smgy'U]", "[bdsk'U]", "[ka'U]", "[knk'U]", "[mclg'U]", "[tb'U]", "[CCID_50]", "[TCID_50]", "[EID_50]", "[PFU]", "[FFU]", "[CFU]", "[IR]", "[BAU]", "[AU]", "[Amb'a'1'U]", "[PNU]", "[Lf]", "[D'ag'U]", "[FEU]", "[ELU]", "[EU]", "Np", "B", "B[SPL]", "B[V]", "B[mV]", "B[uV]", "B[10.nV]", "B[W]", "B[kW]", "st", "Ao", "b", "att", "mho", "[psi]", "circ", "sph", "[car_m]", "[car_Au]", "[smoot]", "[m/s2/Hz^(1/2)]", "bit_s", "bit", "By", "Bd"};
    public static final Set<String> ATOMSYMBOL_SET = new HashSet<String>(Arrays.asList(ATOMSYMBOL_VALUES));
    public static final String[] PREFIX_VALUES = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "u", "n", "p", "f", "a", "z", "y", "Gi", "Mi", "Gi", "Ti"};
    public static final Set<String> PREFIX_SET = new HashSet<String>(Arrays.asList(PREFIX_VALUES));
    static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();

    public boolean isValidUnitsString(String units) {
        boolean isValid = this.isMainTerm(units);
        return isValid;
    }

    private boolean isMainTerm(String units) {
        return units.length() == 0 || units.equals(" ") || this.isTerm(units) || units.startsWith("/") && this.isTerm(units.substring(1));
    }

    private boolean isTerm(String units) {
        String[] components;
        boolean roundBracketsOk = this.checkRoundBrackets(units);
        if (!roundBracketsOk) {
            return false;
        }
        if ((units = units.replace("(", "").replace(")", "")).startsWith("/")) {
            units = units.substring(1);
        }
        if (units.endsWith("/") || units.endsWith(".") || units.endsWith("/)") || units.endsWith(".)")) {
            return false;
        }
        for (String component : components = units.split("/|\\.")) {
            if (this.isComponent(component)) continue;
            return false;
        }
        return true;
    }

    private boolean checkRoundBrackets(String units) {
        int i;
        String unitsT = units;
        int openingBrackets = unitsT.startsWith("(") ? 1 : 0;
        int closingBrackets = unitsT.endsWith(")") ? 1 : 0;
        for (i = 1; i < unitsT.length(); ++i) {
            if (unitsT.charAt(i) != '(') continue;
            ++openingBrackets;
            if (unitsT.charAt(i - 1) == '.' || unitsT.charAt(i - 1) == '/') continue;
            return false;
        }
        for (i = 0; i < unitsT.length() - 1; ++i) {
            if (unitsT.charAt(i) != ')') continue;
            ++closingBrackets;
            if (unitsT.charAt(i + 1) == '.' || unitsT.charAt(i + 1) == '/') continue;
            return false;
        }
        return openingBrackets == closingBrackets;
    }

    private boolean isComponent(String component) {
        boolean isComponent;
        boolean bl = isComponent = this.isAnnotatable(component) || this.isAnnotation(component) || this.isFactor(component);
        if (!isComponent && component.endsWith("}") && component.indexOf("{") > 0) {
            isComponent = this.isAnnotatable(component.substring(0, component.indexOf("{"))) && this.isAnnotation(component.substring(component.indexOf("{")));
        }
        return isComponent;
    }

    private boolean isFactor(String component) {
        try {
            Integer.parseInt(component);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean isAnnotation(String component) {
        boolean isAnnotation;
        boolean bl = isAnnotation = component.startsWith("{") && component.endsWith("}") && this.isPureAscii(component.substring(1, component.length() - 1));
        if (isAnnotation) {
            String compExclCurly = component.substring(1, component.length() - 1);
            isAnnotation = !compExclCurly.contains("{") && !compExclCurly.contains("}");
        }
        return isAnnotation;
    }

    private boolean isAnnotatable(String component) {
        if (component.equals("1")) {
            return true;
        }
        if (component.length() > 0) {
            boolean hadDigit = false;
            while (component.length() > 0 && this.isDigit(component.substring(component.length() - 1))) {
                component = component.substring(0, component.length() - 1);
                hadDigit = true;
            }
            if (hadDigit && component.length() > 0 && this.isSign(component.substring(component.length() - 1))) {
                component = component.substring(0, component.length() - 1);
            }
        }
        return this.isSimpleUnit(component);
    }

    boolean isSign(String str) {
        return str.equals("+") || str.equals("-");
    }

    boolean isDigit(String str) {
        return this.isFactor(str);
    }

    private boolean isSimpleUnit(String component) {
        return this.isAtomSymbol(component) || component.length() >= 1 && this.isPrefixSymbol(component.substring(0, 1)) && this.isAtomSymbol(component.substring(1)) || component.length() >= 2 && this.isPrefixSymbol(component.substring(0, 2)) && this.isAtomSymbol(component.substring(2));
    }

    private boolean isAtomSymbol(String component) {
        return ATOMSYMBOL_SET.contains(component);
    }

    private boolean isPrefixSymbol(String ch) {
        return PREFIX_SET.contains(ch);
    }

    private boolean isPureAscii(String v) {
        return asciiEncoder.canEncode(v);
    }
}

