/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.xpath.api.QNameReferent;
import org.opendaylight.yangtools.yang.xpath.api.ResolvedQNameReferent;
import org.opendaylight.yangtools.yang.xpath.api.UnresolvedQNameReferent;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangPredicateAware;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathNodeType;

public abstract sealed class YangLocationPath
implements YangExpr {
    private static final long serialVersionUID = 1L;
    private static final Absolute ROOT = new Absolute((ImmutableList<Step>)ImmutableList.of());
    private static final Relative SELF = new Relative((ImmutableList<Step>)ImmutableList.of());
    private final ImmutableList<Step> steps;

    private YangLocationPath(ImmutableList<Step> steps) {
        this.steps = Objects.requireNonNull(steps);
    }

    public static final Absolute absolute(Step ... steps) {
        return YangLocationPath.absolute(Arrays.asList(steps));
    }

    public static final Absolute absolute(Collection<Step> steps) {
        return steps.isEmpty() ? ROOT : new Absolute((ImmutableList<Step>)ImmutableList.copyOf(steps));
    }

    public static final Relative relative(Step ... steps) {
        return YangLocationPath.relative(Arrays.asList(steps));
    }

    public static final Relative relative(Collection<Step> steps) {
        return steps.isEmpty() ? SELF : new Relative((ImmutableList<Step>)ImmutableList.copyOf(steps));
    }

    public static final Absolute root() {
        return ROOT;
    }

    public static final Relative self() {
        return SELF;
    }

    public final ImmutableList<Step> getSteps() {
        return this.steps;
    }

    public abstract boolean isAbsolute();

    public final int hashCode() {
        return Boolean.hashCode(this.isAbsolute()) * 31 + this.steps.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof YangLocationPath)) return false;
        YangLocationPath other = (YangLocationPath)obj;
        if (this.isAbsolute() != other.isAbsolute()) return false;
        if (!this.steps.equals(other.steps)) return false;
        return true;
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(YangLocationPath.class).add("absolute", this.isAbsolute());
        if (!this.steps.isEmpty()) {
            helper.add("steps", this.steps);
        }
        return helper.toString();
    }

    final Object readSolve() {
        return this.steps.isEmpty() ? (this.isAbsolute() ? ROOT : SELF) : this;
    }

    public static final class Absolute
    extends YangLocationPath {
        private static final long serialVersionUID = 1L;

        Absolute(ImmutableList<Step> steps) {
            super(steps);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }
    }

    public static final class Relative
    extends YangLocationPath {
        private static final long serialVersionUID = 1L;

        Relative(ImmutableList<Step> steps) {
            super(steps);
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }
    }

    static final class ProcessingInstructionStepWithPredicates
    extends ProcessingInstructionStep {
        private static final long serialVersionUID = 1L;
        private final ImmutableSet<YangExpr> predicates;

        ProcessingInstructionStepWithPredicates(YangXPathAxis axis, String name, ImmutableSet<YangExpr> predicates) {
            super(axis, name);
            this.predicates = Objects.requireNonNull(predicates);
        }

        public ImmutableSet<YangExpr> getPredicates() {
            return this.predicates;
        }
    }

    public static sealed class ProcessingInstructionStep
    extends NodeTypeStep
    permits ProcessingInstructionStepWithPredicates {
        private static final long serialVersionUID = 1L;
        private final String name;

        ProcessingInstructionStep(YangXPathAxis axis, String name) {
            super(axis, YangXPathNodeType.PROCESSING_INSTRUCTION);
            this.name = Objects.requireNonNull(name);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(new Object[]{this.getAxis(), this.getNodeType(), this.name, this.getPredicates()});
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            return obj == this || super.equals(obj) && this.name.equals(((ProcessingInstructionStep)obj).name);
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("name", (Object)this.name);
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="https://github.com/spotbugs/spotbugs/issues/511")
    static final class NodeTypeStepWithPredicates
    extends NodeTypeStep {
        private static final long serialVersionUID = 1L;
        private final ImmutableSet<YangExpr> predicates;

        NodeTypeStepWithPredicates(YangXPathAxis axis, YangXPathNodeType type, ImmutableSet<YangExpr> predicates) {
            super(axis, type);
            this.predicates = Objects.requireNonNull(predicates);
        }

        public ImmutableSet<YangExpr> getPredicates() {
            return this.predicates;
        }
    }

    public static sealed class NodeTypeStep
    extends Step
    permits NodeTypeStepWithPredicates, ProcessingInstructionStep {
        private static final long serialVersionUID = 1L;
        private final YangXPathNodeType nodeType;

        NodeTypeStep(YangXPathAxis axis, YangXPathNodeType nodeType) {
            super(axis);
            this.nodeType = Objects.requireNonNull(nodeType);
        }

        public final YangXPathNodeType getNodeType() {
            return this.nodeType;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.getAxis(), this.nodeType, this.getPredicates()});
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            NodeTypeStep other = (NodeTypeStep)obj;
            return this.nodeType.equals((Object)other.nodeType) && this.getAxis().equals((Object)other.getAxis()) && this.getPredicates().equals(other.getPredicates());
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("nodeType", (Object)this.nodeType);
        }
    }

    private static final class UnresolvedQNameStepWithPredicates
    extends UnresolvedQNameStep {
        private static final long serialVersionUID = 1L;
        private final ImmutableSet<YangExpr> predicates;

        UnresolvedQNameStepWithPredicates(YangXPathAxis axis, UnresolvedQName qname, ImmutableSet<YangExpr> predicates) {
            super(axis, qname);
            this.predicates = Objects.requireNonNull(predicates);
        }

        public ImmutableSet<YangExpr> getPredicates() {
            return this.predicates;
        }
    }

    public static sealed class UnresolvedQNameStep
    extends AbstractQNameStep<UnresolvedQName>
    implements UnresolvedQNameReferent
    permits UnresolvedQNameStepWithPredicates {
        private static final long serialVersionUID = 1L;

        UnresolvedQNameStep(YangXPathAxis axis, UnresolvedQName qname) {
            super(axis, qname);
        }

        static UnresolvedQNameStep of(YangXPathAxis axis, UnresolvedQName qname, Collection<YangExpr> predicates) {
            return predicates.isEmpty() ? new UnresolvedQNameStep(axis, qname) : new UnresolvedQNameStepWithPredicates(axis, qname, (ImmutableSet<YangExpr>)ImmutableSet.copyOf(predicates));
        }

        @Override
        final Class<UnresolvedQNameStep> equalityClass() {
            return UnresolvedQNameStep.class;
        }
    }

    private static final class ResolvedQNameStepWithPredicates
    extends ResolvedQNameStep {
        private static final long serialVersionUID = 1L;
        private final ImmutableSet<YangExpr> predicates;

        ResolvedQNameStepWithPredicates(YangXPathAxis axis, QName qname, ImmutableSet<YangExpr> predicates) {
            super(axis, qname);
            this.predicates = Objects.requireNonNull(predicates);
        }

        public ImmutableSet<YangExpr> getPredicates() {
            return this.predicates;
        }
    }

    public static sealed class ResolvedQNameStep
    extends AbstractQNameStep<QName>
    implements ResolvedQNameReferent
    permits ResolvedQNameStepWithPredicates {
        private static final long serialVersionUID = 1L;

        ResolvedQNameStep(YangXPathAxis axis, QName qname) {
            super(axis, qname);
        }

        static ResolvedQNameStep of(YangXPathAxis axis, QName qname, Collection<YangExpr> predicates) {
            return predicates.isEmpty() ? new ResolvedQNameStep(axis, qname) : new ResolvedQNameStepWithPredicates(axis, qname, (ImmutableSet<YangExpr>)ImmutableSet.copyOf(predicates));
        }

        @Override
        final Class<ResolvedQNameStep> equalityClass() {
            return ResolvedQNameStep.class;
        }
    }

    private static abstract sealed class AbstractQNameStep<T extends AbstractQName>
    extends QNameStep
    permits ResolvedQNameStep, UnresolvedQNameStep {
        private static final long serialVersionUID = 1L;
        private final T qname;

        AbstractQNameStep(YangXPathAxis axis, T qname) {
            super(axis);
            this.qname = (AbstractQName)Objects.requireNonNull(qname);
        }

        public final @NonNull T getQName() {
            return this.qname;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(new Object[]{this.getAxis(), this.qname, this.getPredicates()});
        }

        @Override
        @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Polymorphic via equalityClass()")
        public final boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            Class<AbstractQNameStep<?>> eq = this.equalityClass();
            if (!this.equalityClass().isInstance(obj)) {
                return false;
            }
            AbstractQNameStep<?> other = eq.cast(obj);
            return this.getAxis().equals((Object)other.getAxis()) && this.qname.equals(other.qname) && this.getPredicates().equals(other.getPredicates());
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("qname", this.qname);
        }

        abstract Class<? extends AbstractQNameStep<?>> equalityClass();
    }

    public static abstract sealed class QNameStep
    extends Step
    implements QNameReferent
    permits AbstractQNameStep {
        private static final long serialVersionUID = 1L;

        QNameStep(YangXPathAxis axis) {
            super(axis);
        }
    }

    public static final class NamespaceStep
    extends Step {
        private static final long serialVersionUID = 1L;
        private final QNameModule namespace;

        NamespaceStep(YangXPathAxis axis, QNameModule namespace) {
            super(axis);
            this.namespace = Objects.requireNonNull(namespace);
        }

        public QNameModule getNamespace() {
            return this.namespace;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.getAxis(), this.namespace, this.getPredicates()});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof NamespaceStep)) return false;
            NamespaceStep other = (NamespaceStep)obj;
            if (!this.getAxis().equals((Object)other.getAxis())) return false;
            if (!this.namespace.equals((Object)other.namespace)) return false;
            if (!this.getPredicates().equals(other.getPredicates())) return false;
            return true;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("namespace", (Object)this.namespace);
        }
    }

    static final class AxisStepWithPredicates
    extends AxisStep {
        private static final long serialVersionUID = 1L;
        private final ImmutableSet<YangExpr> predicates;

        AxisStepWithPredicates(YangXPathAxis axis, ImmutableSet<YangExpr> predicates) {
            super(axis);
            this.predicates = Objects.requireNonNull(predicates);
        }

        public ImmutableSet<YangExpr> getPredicates() {
            return this.predicates;
        }
    }

    public static sealed class AxisStep
    extends Step
    permits AxisStepWithPredicates {
        private static final long serialVersionUID = 1L;

        AxisStep(YangXPathAxis axis) {
            super(axis);
        }

        @Override
        public final int hashCode() {
            return Objects.hash(new Object[]{this.getAxis(), this.getPredicates()});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof AxisStep)) return false;
            AxisStep other = (AxisStep)obj;
            if (!this.getAxis().equals((Object)other.getAxis())) return false;
            if (!this.getPredicates().equals(other.getPredicates())) return false;
            return true;
        }

        @SuppressFBWarnings(value={"SE_PRIVATE_READ_RESOLVE_NOT_INHERITED"}, justification="We have only one subclass, and that does not want to inherit this")
        private Object readResolve() {
            return this.getAxis().asStep();
        }
    }

    public static abstract sealed class Step
    implements Serializable,
    YangPredicateAware
    permits AxisStep, NamespaceStep, QNameStep, NodeTypeStep {
        private static final long serialVersionUID = 1L;
        private final YangXPathAxis axis;

        Step(YangXPathAxis axis) {
            this.axis = Objects.requireNonNull(axis);
        }

        public final YangXPathAxis getAxis() {
            return this.axis;
        }

        public abstract int hashCode();

        public abstract boolean equals(@Nullable Object var1);

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper(Step.class)).toString();
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            helper.add("axis", (Object)this.axis);
            Set<YangExpr> predicates = this.getPredicates();
            if (!predicates.isEmpty()) {
                helper.add("predicates", predicates);
            }
            return helper;
        }
    }
}

