/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.source.SourceDependency;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;

@Beta
public class SchemaResolutionException
extends SchemaSourceException {
    private static final long serialVersionUID = 2L;
    private final @NonNull ImmutableMultimap<SourceIdentifier, SourceDependency> unsatisfiedImports;
    private final @NonNull ImmutableList<SourceIdentifier> resolvedSources;

    public SchemaResolutionException(@NonNull String message, SourceIdentifier failedSource, Throwable cause) {
        this(message, failedSource, cause, (Collection<SourceIdentifier>)ImmutableList.of(), (Multimap<SourceIdentifier, SourceDependency>)ImmutableMultimap.of());
    }

    public SchemaResolutionException(@NonNull String message, SourceIdentifier failedSource, @NonNull Collection<SourceIdentifier> resolvedSources, @NonNull Multimap<SourceIdentifier, SourceDependency> unsatisfiedImports) {
        this(message, failedSource, null, resolvedSources, unsatisfiedImports);
    }

    public SchemaResolutionException(@NonNull String message, SourceIdentifier failedSource, Throwable cause, @NonNull Collection<SourceIdentifier> resolvedSources, @NonNull Multimap<SourceIdentifier, SourceDependency> unsatisfiedImports) {
        super(failedSource, SchemaResolutionException.formatMessage(message, failedSource, resolvedSources, unsatisfiedImports), cause);
        this.unsatisfiedImports = ImmutableMultimap.copyOf(unsatisfiedImports);
        this.resolvedSources = ImmutableList.copyOf(resolvedSources);
    }

    private static String formatMessage(String message, SourceIdentifier failedSource, Collection<?> resolvedSources, Multimap<?, ?> unsatisfiedImports) {
        return String.format("%s, failed source: %s, resolved sources: %s, unsatisfied imports: %s", message, failedSource, resolvedSources, unsatisfiedImports);
    }

    public final @NonNull Multimap<SourceIdentifier, SourceDependency> getUnsatisfiedImports() {
        return this.unsatisfiedImports;
    }

    public final @NonNull Collection<SourceIdentifier> getResolvedSources() {
        return this.resolvedSources;
    }

    @Override
    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("unsatisfiedImports", this.unsatisfiedImports)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }
}

