/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefEnumSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class EnumSpecificationSupport
extends AbstractTypeSupport<TypeStatement.EnumSpecification> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.ENUM).build();

    EnumSpecificationSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
    }

    protected TypeStatement.EnumSpecification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw EnumSpecificationSupport.noEnum(ctx);
        }
        return new EnumSpecificationImpl(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.EnumSpecification attachDeclarationReference(TypeStatement.EnumSpecification stmt, DeclarationReference reference) {
        return new RefEnumSpecification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.EnumSpecification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.EnumSpecification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw EnumSpecificationSupport.noEnum(stmt);
        }
        EnumerationTypeBuilder builder = BaseTypes.enumerationTypeBuilder((QName)stmt.argumentAsTypeQName());
        Integer highestValue = null;
        for (EffectiveStatement subStmt : substatements) {
            int effectiveValue;
            if (!(subStmt instanceof EnumEffectiveStatement)) continue;
            EnumEffectiveStatement enumSubStmt = (EnumEffectiveStatement)subStmt;
            Optional declaredValue = enumSubStmt.findFirstEffectiveSubstatementArgument(ValueEffectiveStatement.class);
            if (declaredValue.isEmpty()) {
                if (highestValue != null) {
                    SourceException.throwIf((highestValue == Integer.MAX_VALUE ? 1 : 0) != 0, stmt, (String)"Enum '%s' must have a value statement", (Object[])new Object[]{enumSubStmt});
                    effectiveValue = highestValue + 1;
                } else {
                    effectiveValue = 0;
                }
            } else {
                effectiveValue = (Integer)declaredValue.orElseThrow();
            }
            EnumTypeDefinition.EnumPair pair = EffectiveTypeUtil.buildEnumPair(enumSubStmt, effectiveValue);
            if (highestValue == null || highestValue < pair.getValue()) {
                highestValue = pair.getValue();
            }
            builder.addEnum(pair);
        }
        return new TypeEffectiveStatementImpl((TypeStatement.EnumSpecification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static SourceException noEnum(CommonStmtCtx stmt) {
        return new SourceException("At least one enum statement has to be present", stmt);
    }
}

