/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveModule;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class SubmoduleEffectiveStatementImpl
extends AbstractEffectiveModule<SubmoduleStatement, SubmoduleEffectiveStatement>
implements Submodule,
SubmoduleEffectiveStatement,
MutableStatement {
    private final ImmutableMap<String, ModuleEffectiveStatement> prefixToModule;
    private final ImmutableMap<QNameModule, String> namespaceToPrefix;
    private final QNameModule qnameModule;
    private ImmutableSet<StmtContext<?, SubmoduleStatement, SubmoduleEffectiveStatement>> submoduleContexts;
    private ImmutableSet<Submodule> submodules;
    private boolean sealed;

    SubmoduleEffectiveStatementImpl(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, SubmoduleStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        super(stmt, substatements, SubmoduleEffectiveStatementImpl.findSubmodulePrefix(stmt, substatements));
        QNameModule belongsToModuleQName = (QNameModule)stmt.namespaceItem(ParserNamespaces.MODULE_NAME_TO_QNAME, (Object)((UnresolvedQName.Unqualified)SubmoduleEffectiveStatementImpl.findBelongsTo(stmt, substatements).argument()));
        ImmutableMap.Builder prefixToModuleBuilder = ImmutableMap.builder();
        this.appendPrefixes(stmt, (ImmutableMap.Builder<String, ModuleEffectiveStatement>)prefixToModuleBuilder);
        this.prefixToModule = prefixToModuleBuilder.build();
        LinkedHashMap<QNameModule, String> tmp = LinkedHashMap.newLinkedHashMap(this.prefixToModule.size());
        for (Map.Entry e : this.prefixToModule.entrySet()) {
            tmp.putIfAbsent(((ModuleEffectiveStatement)e.getValue()).localQNameModule(), (String)e.getKey());
        }
        this.namespaceToPrefix = ImmutableMap.copyOf(tmp);
        Optional submoduleRevision = this.findFirstEffectiveSubstatementArgument(RevisionEffectiveStatement.class);
        this.qnameModule = QNameModule.ofRevision((XMLNamespace)belongsToModuleQName.namespace(), (Revision)submoduleRevision.orElse(null)).intern();
        Map includedSubmodulesMap = stmt.localNamespacePortion(ParserNamespaces.INCLUDED_SUBMODULE_NAME_TO_MODULECTX);
        if (includedSubmodulesMap != null) {
            HashSet<StmtContext> submoduleContextsInit = new HashSet<StmtContext>();
            for (StmtContext submoduleCtx : includedSubmodulesMap.values()) {
                submoduleContextsInit.add(submoduleCtx);
            }
            this.submoduleContexts = ImmutableSet.copyOf(submoduleContextsInit);
        } else {
            this.submoduleContexts = ImmutableSet.of();
        }
        if (this.submoduleContexts.isEmpty()) {
            this.submodules = ImmutableSet.of();
            this.sealed = true;
        } else {
            this.sealed = false;
        }
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }

    public Collection<Map.Entry<String, ModuleEffectiveStatement>> reachableModules() {
        return this.prefixToModule.entrySet();
    }

    public Optional<ModuleEffectiveStatement> findReachableModule(String prefix) {
        return SubmoduleEffectiveStatementImpl.findValue(this.prefixToModule, (Object)prefix);
    }

    public Collection<Map.Entry<QNameModule, String>> namespacePrefixes() {
        return this.namespaceToPrefix.entrySet();
    }

    public Optional<String> findNamespacePrefix(QNameModule namespace) {
        return SubmoduleEffectiveStatementImpl.findValue(this.namespaceToPrefix, (Object)namespace);
    }

    public Collection<? extends @NonNull Submodule> getSubmodules() {
        Preconditions.checkState((boolean)this.sealed, (String)"Attempt to get base submodules from unsealed submodule effective statement %s", (Object)this.qnameModule);
        return this.submodules;
    }

    public SubmoduleEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public void seal() {
        if (!this.sealed) {
            this.submodules = ImmutableSet.copyOf((Iterable)Iterables.transform(this.submoduleContexts, ctx -> (Submodule)ctx.buildEffective()));
            this.submoduleContexts = ImmutableSet.of();
            this.sealed = true;
        }
    }

    private static @NonNull BelongsToEffectiveStatement findBelongsTo(CommonStmtCtx stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return substatements.stream().filter(BelongsToEffectiveStatement.class::isInstance).map(BelongsToEffectiveStatement.class::cast).findAny().orElseThrow(() -> new SourceException(stmt, "Unable to find belongs-to statement in submodule %s.", new Object[]{stmt.rawArgument()}));
    }

    private static @NonNull String findSubmodulePrefix(CommonStmtCtx stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return SubmoduleEffectiveStatementImpl.findPrefix(stmt, SubmoduleEffectiveStatementImpl.findBelongsTo(stmt, substatements).effectiveSubstatements(), "submodule", stmt.getRawArgument());
    }
}

