/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceException;
import org.opendaylight.yangtools.yang.parser.antlr.LeafRefPathLexer;
import org.opendaylight.yangtools.yang.parser.antlr.LeafRefPathParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.SourceExceptionParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.ParsedPathExpression;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.UnparsedPathExpression;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangPathExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PathExpressionParser {
    private static final YangFunctionCallExpr CURRENT_CALL = YangFunctionCallExpr.of((QName)YangFunction.CURRENT.getIdentifier());

    PathExpressionParser() {
    }

    PathExpression parseExpression(StmtContext<?, ?, ?> ctx, String pathArg) {
        ParseTree childPath;
        LeafRefPathLexer lexer = new LeafRefPathLexer((CharStream)CharStreams.fromString((String)pathArg));
        LeafRefPathParser parser = new LeafRefPathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        LeafRefPathParser.Path_argContext path = SourceExceptionParser.parse(lexer, parser, parser::path_arg, ctx.sourceReference());
        ParseTree parseTree = childPath = path.getChild(0);
        Objects.requireNonNull(parseTree);
        ParseTree parseTree2 = parseTree;
        int n = 0;
        PathExpression.LocationPathSteps steps = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafRefPathParser.Path_strContext.class, LeafRefPathParser.Deref_exprContext.class}, (Object)parseTree2, n)) {
            case 0 -> {
                LeafRefPathParser.Path_strContext str = (LeafRefPathParser.Path_strContext)parseTree2;
                yield new PathExpression.LocationPathSteps(PathExpressionParser.parsePathStr(ctx, pathArg, str));
            }
            case 1 -> {
                LeafRefPathParser.Deref_exprContext deref = (LeafRefPathParser.Deref_exprContext)parseTree2;
                yield new PathExpression.DerefSteps(PathExpressionParser.parseRelative(ctx, pathArg, (LeafRefPathParser.Relative_pathContext)PathExpressionParser.getChild((ParseTree)deref, 0, LeafRefPathParser.Deref_function_invocationContext.class).getChild(LeafRefPathParser.Relative_pathContext.class, 0)), PathExpressionParser.parseRelative(ctx, pathArg, PathExpressionParser.getChild((ParseTree)deref, deref.getChildCount() - 1, LeafRefPathParser.Relative_pathContext.class)));
            }
            default -> throw new IllegalStateException("Unsupported child " + String.valueOf(childPath));
        };
        return new ParsedPathExpression((PathExpression.Steps)steps, pathArg);
    }

    private static YangLocationPath parsePathStr(StmtContext<?, ?, ?> ctx, String pathArg, LeafRefPathParser.Path_strContext path) {
        ParseTree childPath;
        ParseTree parseTree = childPath = path.getChild(0);
        Objects.requireNonNull(parseTree);
        ParseTree parseTree2 = parseTree;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafRefPathParser.Absolute_pathContext.class, LeafRefPathParser.Relative_pathContext.class}, (Object)parseTree2, n)) {
            case 0 -> {
                LeafRefPathParser.Absolute_pathContext absolute = (LeafRefPathParser.Absolute_pathContext)parseTree2;
                yield PathExpressionParser.parseAbsolute(ctx, pathArg, absolute);
            }
            case 1 -> {
                LeafRefPathParser.Relative_pathContext relative = (LeafRefPathParser.Relative_pathContext)parseTree2;
                yield PathExpressionParser.parseRelative(ctx, pathArg, relative);
            }
            default -> throw new IllegalStateException("Unsupported child " + String.valueOf(childPath));
        };
    }

    private static YangLocationPath.Absolute parseAbsolute(StmtContext<?, ?, ?> ctx, String pathArg, LeafRefPathParser.Absolute_pathContext absolute) {
        ArrayList<YangLocationPath.Step> steps = new ArrayList<YangLocationPath.Step>();
        PathExpressionParser.fillSteps(ctx, pathArg, absolute, steps);
        return YangLocationPath.absolute(steps);
    }

    private static YangLocationPath.Relative parseRelative(StmtContext<?, ?, ?> ctx, String pathArg, LeafRefPathParser.Relative_pathContext relative) {
        int relativeChildren = relative.getChildCount();
        Verify.verify((relativeChildren % 2 != 0 ? 1 : 0) != 0, (String)"Unexpected child count %s", (int)relativeChildren);
        int stepCount = relativeChildren / 2;
        ArrayList<YangLocationPath.Step> steps = new ArrayList<YangLocationPath.Step>(stepCount);
        for (int i = 0; i < stepCount; ++i) {
            steps.add((YangLocationPath.Step)YangXPathAxis.PARENT.asStep());
        }
        return PathExpressionParser.parseRelative(ctx, pathArg, relative, steps);
    }

    private static YangLocationPath.Relative parseRelative(StmtContext<?, ?, ?> ctx, String pathArg, LeafRefPathParser.Relative_pathContext relative, List<YangLocationPath.Step> steps) {
        int relativeChildren = relative.getChildCount();
        LeafRefPathParser.Descendant_pathContext descendant = PathExpressionParser.getChild((ParseTree)relative, relativeChildren - 1, LeafRefPathParser.Descendant_pathContext.class);
        LeafRefPathParser.Node_identifierContext qname = PathExpressionParser.getChild((ParseTree)descendant, 0, LeafRefPathParser.Node_identifierContext.class);
        int descandantChildren = descendant.getChildCount();
        if (descandantChildren > 1) {
            ArrayList<YangExpr> predicates = new ArrayList<YangExpr>(descandantChildren);
            for (int i = 1; i < descandantChildren - 1; ++i) {
                predicates.add((YangExpr)PathExpressionParser.parsePathPredicate(ctx, PathExpressionParser.getChild((ParseTree)descendant, i, LeafRefPathParser.Path_predicateContext.class)));
            }
            steps.add((YangLocationPath.Step)PathExpressionParser.createChildStep(ctx, qname, predicates));
            PathExpressionParser.fillSteps(ctx, pathArg, PathExpressionParser.getChild((ParseTree)descendant, descandantChildren - 1, LeafRefPathParser.Absolute_pathContext.class), steps);
        } else {
            steps.add((YangLocationPath.Step)PathExpressionParser.createChildStep(ctx, qname, (List<YangExpr>)ImmutableList.of()));
        }
        return YangLocationPath.relative(steps);
    }

    private static void fillSteps(StmtContext<?, ?, ?> ctx, String pathArg, LeafRefPathParser.Absolute_pathContext absolute, List<YangLocationPath.Step> output) {
        ArrayList<YangExpr> predicates = new ArrayList<YangExpr>();
        LeafRefPathParser.Node_identifierContext qname = PathExpressionParser.getChild((ParseTree)absolute, 1, LeafRefPathParser.Node_identifierContext.class);
        int children = absolute.getChildCount();
        block4: for (int i = 2; i < children; ++i) {
            ParseTree parseTree;
            Objects.requireNonNull(absolute.getChild(i));
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafRefPathParser.Node_identifierContext.class, LeafRefPathParser.Path_predicateContext.class}, (Object)parseTree, n)) {
                case 0: {
                    LeafRefPathParser.Node_identifierContext identifier = (LeafRefPathParser.Node_identifierContext)parseTree;
                    output.add((YangLocationPath.Step)PathExpressionParser.createChildStep(ctx, qname, predicates));
                    predicates.clear();
                    qname = identifier;
                    continue block4;
                }
                case 1: {
                    LeafRefPathParser.Path_predicateContext predicate = (LeafRefPathParser.Path_predicateContext)parseTree;
                    predicates.add((YangExpr)PathExpressionParser.parsePathPredicate(ctx, predicate));
                    continue block4;
                }
            }
        }
        output.add((YangLocationPath.Step)PathExpressionParser.createChildStep(ctx, qname, predicates));
    }

    private static <T> T getChild(ParseTree parent, int offset, Class<T> clazz) {
        ParseTree child = parent.getChild(offset);
        Verify.verify((boolean)clazz.isInstance(child), (String)"Unexpected child %s at offset %s of %s when expecting %s", (Object)child, (Object)offset, (Object)parent, clazz);
        return clazz.cast(child);
    }

    private static YangBinaryExpr parsePathPredicate(StmtContext<?, ?, ?> ctx, LeafRefPathParser.Path_predicateContext predicate) {
        LeafRefPathParser.Path_equality_exprContext eqExpr = (LeafRefPathParser.Path_equality_exprContext)((Object)Verify.verifyNotNull((Object)((Object)predicate.path_equality_expr())));
        return YangBinaryOperator.EQUALS.exprWith((YangExpr)PathExpressionParser.createChildExpr(ctx, PathExpressionParser.getChild((ParseTree)eqExpr, 0, LeafRefPathParser.Node_identifierContext.class)), PathExpressionParser.parsePathKeyExpr(ctx, (LeafRefPathParser.Path_key_exprContext)((Object)Verify.verifyNotNull((Object)((Object)eqExpr.path_key_expr())))));
    }

    private static YangExpr parsePathKeyExpr(StmtContext<?, ?, ?> ctx, LeafRefPathParser.Path_key_exprContext expr) {
        ParseTree child;
        int offset;
        LeafRefPathParser.Rel_path_keyexprContext relPath = (LeafRefPathParser.Rel_path_keyexprContext)((Object)Verify.verifyNotNull((Object)((Object)expr.rel_path_keyexpr())));
        int children = relPath.getChildCount();
        ArrayList<Object> steps = new ArrayList<Object>();
        for (offset = 0; offset < children - 1 && !((child = relPath.getChild(offset)) instanceof LeafRefPathParser.Node_identifierContext); ++offset) {
            TerminalNode terminal;
            if (!(child instanceof TerminalNode) || (terminal = (TerminalNode)child).getSymbol().getType() != 3) continue;
            steps.add(YangXPathAxis.PARENT.asStep());
        }
        while (offset < children) {
            ParseTree parseTree = relPath.getChild(offset);
            if (parseTree instanceof LeafRefPathParser.Node_identifierContext) {
                LeafRefPathParser.Node_identifierContext identifier = (LeafRefPathParser.Node_identifierContext)parseTree;
                steps.add(PathExpressionParser.createChildStep(ctx, identifier, (List<YangExpr>)ImmutableList.of()));
            }
            ++offset;
        }
        return steps.isEmpty() ? CURRENT_CALL : YangPathExpr.of((YangExpr)CURRENT_CALL, (YangLocationPath.Relative)YangLocationPath.relative(steps));
    }

    private static YangQNameExpr createChildExpr(StmtContext<?, ?, ?> ctx, LeafRefPathParser.Node_identifierContext qname) {
        return switch (qname.getChildCount()) {
            case 1 -> YangQNameExpr.of((UnresolvedQName)UnresolvedQName.Unqualified.of((String)qname.getText()).intern());
            case 3 -> YangQNameExpr.of((QName)PathExpressionParser.parseQName(ctx, qname));
            default -> throw new IllegalStateException("Unexpected shape " + qname.getText());
        };
    }

    private static YangLocationPath.QNameStep createChildStep(StmtContext<?, ?, ?> ctx, LeafRefPathParser.Node_identifierContext qname, List<YangExpr> predicates) {
        return switch (qname.getChildCount()) {
            case 1 -> YangXPathAxis.CHILD.asStep((UnresolvedQName)UnresolvedQName.Unqualified.of((String)qname.getText()).intern(), predicates);
            case 3 -> YangXPathAxis.CHILD.asStep(PathExpressionParser.parseQName(ctx, qname), predicates);
            default -> throw new IllegalStateException("Unexpected shape " + qname.getText());
        };
    }

    private static @NonNull QName parseQName(StmtContext<?, ?, ?> ctx, LeafRefPathParser.Node_identifierContext qname) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)qname.getChild(0).getText(), (String)qname.getChild(2).getText());
    }

    static final class Lenient
    extends PathExpressionParser {
        private static final Logger LOG = LoggerFactory.getLogger(Lenient.class);

        Lenient() {
        }

        @Override
        PathExpression parseExpression(StmtContext<?, ?, ?> ctx, String pathArg) {
            try {
                return super.parseExpression(ctx, pathArg);
            }
            catch (IllegalStateException | StatementSourceException e) {
                LOG.warn("Failed to parse expression '{}'", (Object)pathArg, (Object)e);
                return new UnparsedPathExpression(pathArg, (RuntimeException)e);
            }
        }
    }
}

