/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class OrderedByStatementSupport
extends AbstractStatementSupport<Ordering, OrderedByStatement, OrderedByEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ORDERED_BY).build();
    private static final @NonNull OrderedByStatement EMPTY_SYSTEM_DECL = DeclaredStatements.createOrderedBy((Ordering)Ordering.SYSTEM);
    private static final @NonNull OrderedByStatement EMPTY_USER_DECL = DeclaredStatements.createOrderedBy((Ordering)Ordering.USER);
    private static final @NonNull OrderedByEffectiveStatement EMPTY_SYSTEM_EFF = EffectiveStatements.createOrderedBy((OrderedByStatement)EMPTY_SYSTEM_DECL);
    private static final @NonNull OrderedByEffectiveStatement EMPTY_USER_EFF = EffectiveStatements.createOrderedBy((OrderedByStatement)EMPTY_USER_DECL);

    public OrderedByStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.ORDERED_BY, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Ordering parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Ordering.forArgument((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid ordered-by argument '%s'", new Object[]{value});
        }
    }

    public String internArgument(String rawArgument) {
        if ("user".equals(rawArgument)) {
            return "user";
        }
        if ("system".equals(rawArgument)) {
            return "system";
        }
        return rawArgument;
    }

    protected OrderedByStatement createDeclared(BoundStmtCtx<Ordering> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            Ordering argument = (Ordering)ctx.getArgument();
            switch (argument) {
                case SYSTEM: {
                    return EMPTY_SYSTEM_DECL;
                }
                case USER: {
                    return EMPTY_USER_DECL;
                }
            }
            throw new IllegalStateException("Unhandled argument " + String.valueOf(argument));
        }
        return DeclaredStatements.createOrderedBy((Ordering)((Ordering)ctx.getArgument()), substatements);
    }

    protected OrderedByStatement attachDeclarationReference(OrderedByStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateOrderedBy((OrderedByStatement)stmt, (DeclarationReference)reference);
    }

    protected OrderedByEffectiveStatement createEffective(EffectiveStmtCtx.Current<Ordering, OrderedByStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return substatements.isEmpty() ? OrderedByStatementSupport.createEmptyEffective((OrderedByStatement)stmt.declared()) : EffectiveStatements.createOrderedBy((OrderedByStatement)((OrderedByStatement)stmt.declared()), substatements);
    }

    private static @NonNull OrderedByEffectiveStatement createEmptyEffective(OrderedByStatement declared) {
        if (EMPTY_USER_DECL.equals((Object)declared)) {
            return EMPTY_USER_EFF;
        }
        if (EMPTY_SYSTEM_DECL.equals((Object)declared)) {
            return EMPTY_SYSTEM_EFF;
        }
        return EffectiveStatements.createOrderedBy((OrderedByStatement)declared);
    }
}

