/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierStatement;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class ModifierStatementSupport
extends AbstractStatementSupport<ModifierKind, ModifierStatement, ModifierEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MODIFIER).build();

    public ModifierStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.MODIFIER, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public ModifierKind parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (ModifierKind)SourceException.unwrap((Optional)ModifierKind.parse((String)value), ctx, (String)"'%s' is not valid argument of modifier statement", (Object[])new Object[]{value});
    }

    public String internArgument(String rawArgument) {
        return "invert-match".equals(rawArgument) ? "invert-match" : rawArgument;
    }

    protected ModifierStatement createDeclared(BoundStmtCtx<ModifierKind> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createModifier((ModifierKind)((ModifierKind)ctx.getArgument()), substatements);
    }

    protected ModifierStatement attachDeclarationReference(ModifierStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateModifier((ModifierStatement)stmt, (DeclarationReference)reference);
    }

    protected ModifierEffectiveStatement createEffective(EffectiveStmtCtx.Current<ModifierKind, ModifierStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createModifier((ModifierStatement)((ModifierStatement)stmt.declared()), substatements);
    }
}

