/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class LeafListStatementSupport
extends AbstractSchemaTreeStatementSupport<LeafListStatement, LeafListEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LEAF_LIST).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.ORDERED_BY).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LEAF_LIST).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.ORDERED_BY).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    private LeafListStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.LEAF_LIST, LeafListStatementSupport.instantiatedPolicy(), config, validator);
    }

    public static @NonNull LeafListStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new LeafListStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull LeafListStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new LeafListStatementSupport(config, RFC7950_VALIDATOR);
    }

    protected LeafListStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createLeafList((QName)((QName)ctx.getArgument()), substatements);
    }

    protected LeafListStatement attachDeclarationReference(LeafListStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateLeafList((LeafListStatement)stmt, (DeclarationReference)reference);
    }

    public LeafListEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, LeafListStatement> stmt, LeafListEffectiveStatement original) {
        return EffectiveStatements.copyLeafList((LeafListEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)LeafListStatementSupport.computeFlags(stmt, original.effectiveSubstatements()));
    }

    protected LeafListEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, LeafListStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)((TypeEffectiveStatement)LeafListStatementSupport.findFirstStatement(substatements, TypeEffectiveStatement.class)), stmt, (String)"Leaf-list is missing a 'type' statement", (Object[])new Object[0]);
        ImmutableSet defaultValues = (ImmutableSet)substatements.stream().filter(DefaultEffectiveStatement.class::isInstance).map(DefaultEffectiveStatement.class::cast).map(ModelStatement::argument).collect(ImmutableSet.toImmutableSet());
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(stmt.yangVersion(), typeStmt, (Set<String>)defaultValues), stmt, (String)"Leaf-list '%s' has one of its default values '%s' marked with an if-feature statement.", (Object[])new Object[]{stmt.argument(), defaultValues});
        return EffectiveStatements.createLeafList((LeafListStatement)((LeafListStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)LeafListStatementSupport.computeFlags(stmt, substatements), substatements, (ImmutableSet)defaultValues, (ElementCountConstraint)EffectiveStmtUtils.createElementCountConstraint(stmt, substatements));
    }

    public EffectiveStatementState extractEffectiveState(LeafListEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof LeafListSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        LeafListSchemaNode schema = (LeafListSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setUserOrdered(schema.isUserOrdered()).toFlags());
    }

    private static int computeFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)LeafListStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setUserOrdered(((Ordering)LeafListStatementSupport.findFirstArgument(substatements, OrderedByEffectiveStatement.class, (Object)Ordering.SYSTEM)).equals((Object)Ordering.USER)).toFlags();
    }
}

