/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.UndeclaredStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta.AbstractOperationContainerStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class InputStatementSupport
extends AbstractOperationContainerStatementSupport<InputStatement, InputEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.INPUT).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.INPUT).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).build();

    private InputStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.INPUT, config, validator, YangConstants::operationInputQName);
    }

    public static @NonNull InputStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new InputStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull InputStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new InputStatementSupport(config, RFC7950_VALIDATOR);
    }

    protected InputStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createInput((QName)((QName)ctx.getArgument()), substatements);
    }

    protected InputStatement attachDeclarationReference(InputStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateInput((InputStatement)stmt, (DeclarationReference)reference);
    }

    @Override
    InputEffectiveStatement copyEffective(int flags, EffectiveStmtCtx.Current<QName, InputStatement> stmt, InputEffectiveStatement original) {
        return EffectiveStatements.copyInput((InputEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)flags);
    }

    @Override
    InputEffectiveStatement createEffective(int flags, EffectiveStmtCtx.Current<QName, InputStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        try {
            return EffectiveStatements.createInput((InputStatement)((InputStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)flags, substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    @Override
    InputEffectiveStatement createUndeclaredEffective(int flags, EffectiveStmtCtx.UndeclaredCurrent<QName, InputStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        try {
            return UndeclaredStatements.createInput((QName)((QName)stmt.getArgument()), (int)flags, substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }
}

