/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class BaseStatementSupport
extends AbstractQNameStatementSupport<BaseStatement, BaseEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.BASE).build();

    public BaseStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.BASE, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public void onStatementDefinitionDeclared(final StmtContext.Mutable<QName, BaseStatement, BaseEffectiveStatement> baseStmtCtx) {
        final StmtContext.Mutable baseParentCtx = baseStmtCtx.coerceParentContext();
        if (baseParentCtx.producesDeclared(IdentityStatement.class)) {
            QName baseIdentityQName = (QName)baseStmtCtx.getArgument();
            ModelActionBuilder baseIdentityAction = baseStmtCtx.newInferenceAction(ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.requiresCtx(baseStmtCtx, ParserNamespaces.IDENTITY, (Object)baseIdentityQName, ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.mutatesCtx(baseParentCtx, ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.apply(new ModelActionBuilder.InferenceAction(){

                public void apply(ModelActionBuilder.InferenceContext ctx) {
                }

                public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                    throw new InferenceException((CommonStmtCtx)baseStmtCtx, "Unable to resolve identity %s and base identity %s", new Object[]{baseParentCtx.argument(), baseStmtCtx.argument()});
                }
            });
        }
    }

    protected BaseStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createBase((QName)((QName)ctx.getArgument()), substatements);
    }

    protected BaseStatement attachDeclarationReference(BaseStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateBase((BaseStatement)stmt, (DeclarationReference)reference);
    }

    protected BaseEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, BaseStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createBase((BaseStatement)((BaseStatement)stmt.declared()), substatements);
    }
}

