/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.ConfigListWarningNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ListStatementSupport
extends AbstractSchemaTreeStatementSupport<ListStatement, ListEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(ListStatementSupport.class);
    private static final ImmutableSet<YangStmtMapping> UNINSTANTIATED_DATATREE_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.GROUPING, (Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.INPUT, (Object)YangStmtMapping.OUTPUT);
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.KEY).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.ORDERED_BY).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.ACTION).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.KEY).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.NOTIFICATION).addOptional((StatementDefinition)YangStmtMapping.ORDERED_BY).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private final boolean warnForUnkeyedLists;

    ListStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.LIST, ListStatementSupport.instantiatedPolicy(), config, validator);
        this.warnForUnkeyedLists = config.warnForUnkeyedLists();
    }

    public static @NonNull ListStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new ListStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull ListStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new ListStatementSupport(config, RFC7950_VALIDATOR);
    }

    protected ListStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createList((QName)((QName)ctx.getArgument()), substatements);
    }

    protected ListStatement attachDeclarationReference(ListStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateList((ListStatement)stmt, (DeclarationReference)reference);
    }

    public ListEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, ListStatement> stmt, ListEffectiveStatement original) {
        return EffectiveStatements.copyList((ListEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)ListStatementSupport.computeFlags(stmt, original.effectiveSubstatements()));
    }

    protected ListEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, ListStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        ImmutableList keyDefinition;
        KeyEffectiveStatement keyStmt = (KeyEffectiveStatement)ListStatementSupport.findFirstStatement(substatements, KeyEffectiveStatement.class);
        if (keyStmt != null) {
            ArrayList<QName> keyDefinitionInit = new ArrayList<QName>(keyStmt.argument().size());
            HashSet<QName> possibleLeafQNamesForKey = new HashSet<QName>();
            for (EffectiveStatement effectiveStatement : substatements) {
                if (!(effectiveStatement instanceof LeafSchemaNode)) continue;
                possibleLeafQNamesForKey.add(((LeafSchemaNode)effectiveStatement).getQName());
            }
            for (QName keyQName : keyStmt.argument()) {
                if (!possibleLeafQNamesForKey.contains(keyQName)) {
                    throw new InferenceException(stmt, "Key '%s' misses node '%s' in list '%s'", new Object[]{((KeyStatement)keyStmt.getDeclared()).rawArgument(), keyQName.getLocalName(), stmt.argument()});
                }
                keyDefinitionInit.add(keyQName);
            }
            keyDefinition = ImmutableList.copyOf(keyDefinitionInit);
        } else {
            keyDefinition = ImmutableList.of();
        }
        int flags = ListStatementSupport.computeFlags(stmt, substatements);
        if (this.warnForUnkeyedLists && stmt.effectiveConfig() == EffectiveStmtCtx.Parent.EffectiveConfig.TRUE && keyDefinition.isEmpty() && ListStatementSupport.isInstantied(stmt)) {
            ListStatementSupport.warnConfigList(stmt);
        }
        EffectiveStmtUtils.checkUniqueGroupings(stmt, substatements);
        EffectiveStmtUtils.checkUniqueTypedefs(stmt, substatements);
        EffectiveStmtUtils.checkUniqueUses(stmt, substatements);
        try {
            return EffectiveStatements.createList((ListStatement)((ListStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)flags, substatements, (ImmutableList)keyDefinition, (ElementCountConstraint)EffectiveStmtUtils.createElementCountConstraint(stmt, substatements));
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public EffectiveStatementState extractEffectiveState(ListEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof ListSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        ListSchemaNode schema = (ListSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setUserOrdered(schema.isUserOrdered()).toFlags());
    }

    private static int computeFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)ListStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setUserOrdered(((Ordering)ListStatementSupport.findFirstArgument(substatements, OrderedByEffectiveStatement.class, (Object)Ordering.SYSTEM)).equals((Object)Ordering.USER)).toFlags();
    }

    private static void warnConfigList(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EffectiveStmtCtx.Current<QName, ListStatement> stmt) {
        StatementSourceReference ref = stmt.sourceReference();
        Boolean warned = (Boolean)stmt.namespaceItem(ConfigListWarningNamespace.INSTANCE, (Object)ref);
        if (warned == null) {
            StmtContext ctx = stmt.caerbannog();
            Verify.verify((boolean)(ctx instanceof StmtContext.Mutable), (String)"Unexpected context %s", (Object)ctx);
            ((StmtContext.Mutable)ctx).addToNs(ConfigListWarningNamespace.INSTANCE, (Object)ref, (Object)Boolean.TRUE);
            LOG.info("Configuration list {} does not define any keys in violation of RFC7950 section 7.8.2. While this is fine with OpenDaylight, it can cause interoperability issues with other systems [defined at {}]", stmt.argument(), (Object)ref);
        }
    }

    private static boolean isInstantied(EffectiveStmtCtx ctx) {
        EffectiveStmtCtx.Parent parent = ctx.effectiveParent();
        while (parent != null) {
            StatementDefinition grandParentDef;
            StatementDefinition parentDef = parent.publicDefinition();
            if (UNINSTANTIATED_DATATREE_STATEMENTS.contains((Object)parentDef)) {
                return false;
            }
            EffectiveStmtCtx.Parent grandParent = parent.effectiveParent();
            if (YangStmtMapping.AUGMENT == parentDef && grandParent != null && (YangStmtMapping.MODULE == (grandParentDef = grandParent.publicDefinition()) || YangStmtMapping.SUBMODULE == grandParentDef)) {
                return false;
            }
            parent = grandParent;
        }
        return true;
    }
}

