/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.CompactYangStatementLexer;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.IRSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.StatementContextVisitor;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangErrorListener;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixResolver;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;

@Beta
public final class YangStatementStreamSource
extends AbstractSimpleIdentifiable<SourceIdentifier>
implements StatementStreamSource {
    private final IRStatement rootStatement;
    private final String sourceName;

    private YangStatementStreamSource(SourceIdentifier sourceId, IRStatement rootStatement, String sourceName) {
        super((Object)sourceId);
        this.rootStatement = Objects.requireNonNull(rootStatement);
        this.sourceName = sourceName;
    }

    public static YangStatementStreamSource create(YangTextSource source) throws IOException, YangSyntaxErrorException {
        return new YangStatementStreamSource(source.sourceId(), IRSupport.createStatement(YangStatementStreamSource.parseYangSource(source)), source.symbolicName());
    }

    public static YangStatementStreamSource create(YangIRSource source) {
        return YangStatementStreamSource.create(source.sourceId(), source.statement(), source.symbolicName());
    }

    public static YangStatementStreamSource create(SourceIdentifier identifier, IRStatement rootStatement, String symbolicName) {
        return new YangStatementStreamSource(identifier, rootStatement, symbolicName);
    }

    public void writePreLinkage(StatementWriter writer, QNameToStatementDefinition stmtDef) {
        new StatementContextVisitor(this.sourceName, writer, stmtDef, null, YangVersion.VERSION_1).visit(this.rootStatement);
    }

    public void writeLinkage(StatementWriter writer, final QNameToStatementDefinition stmtDef, PrefixResolver preLinkagePrefixes, YangVersion yangVersion) {
        new StatementContextVisitor(this, this.sourceName, writer, stmtDef, preLinkagePrefixes, yangVersion){

            @Override
            StatementDefinition resolveStatement(QNameModule module, String localName) {
                return stmtDef.getByNamespaceAndLocalName(module.namespace(), localName);
            }
        }.visit(this.rootStatement);
    }

    public void writeLinkageAndStatementDefinitions(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixResolver prefixes, YangVersion yangVersion) {
        new StatementContextVisitor(this.sourceName, writer, stmtDef, prefixes, yangVersion).visit(this.rootStatement);
    }

    public void writeFull(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixResolver prefixes, YangVersion yangVersion) {
        new StatementContextVisitor(this, this.sourceName, writer, stmtDef, prefixes, yangVersion){

            @Override
            QName getValidStatementDefinition(IRKeyword keyword, StatementSourceReference ref) {
                QName ret = super.getValidStatementDefinition(keyword, ref);
                if (ret == null) {
                    throw new SourceException(ref, "%s is not a YANG statement or use of extension.", new Object[]{keyword.asStringDeclaration()});
                }
                return ret;
            }
        }.visit(this.rootStatement);
    }

    IRStatement rootStatement() {
        return this.rootStatement;
    }

    static YangStatementParser.StatementContext parseYangSource(YangTextSource source) throws IOException, YangSyntaxErrorException {
        try (Reader reader = source.openStream();){
            YangStatementParser.StatementContext statementContext = YangStatementStreamSource.parseYangSource(source.sourceId(), reader);
            return statementContext;
        }
    }

    private static YangStatementParser.StatementContext parseYangSource(SourceIdentifier sourceId, Reader stream) throws IOException, YangSyntaxErrorException {
        CompactYangStatementLexer lexer = new CompactYangStatementLexer((CharStream)CharStreams.fromReader((Reader)stream));
        YangStatementParser parser = new YangStatementParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        YangErrorListener errorListener = new YangErrorListener(sourceId);
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        YangStatementParser.FileContext result = parser.file();
        errorListener.validate();
        return (YangStatementParser.StatementContext)((Object)Verify.verifyNotNull((Object)((Object)result.statement())));
    }
}

