/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.InstanceIdentifierTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EmptyIdentifierSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefInstanceIdentifierSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RegularInstanceIdentifierSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

final class InstanceIdentifierSpecificationSupport
extends AbstractTypeSupport<TypeStatement.InstanceIdentifierSpecification> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).build();

    InstanceIdentifierSpecificationSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
    }

    protected TypeStatement.InstanceIdentifierSpecification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return substatements.isEmpty() ? new EmptyIdentifierSpecification(ctx.getRawArgument(), (QName)ctx.getArgument()) : new RegularInstanceIdentifierSpecification(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.InstanceIdentifierSpecification attachDeclarationReference(TypeStatement.InstanceIdentifierSpecification stmt, DeclarationReference reference) {
        return new RefInstanceIdentifierSpecification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.InstanceIdentifierSpecification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.InstanceIdentifierSpecification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        InstanceIdentifierTypeBuilder builder = RestrictedTypes.newInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)BaseTypes.instanceIdentifierType(), (QName)stmt.argumentAsTypeQName());
        for (EffectiveStatement subStmt : substatements) {
            if (!(subStmt instanceof RequireInstanceEffectiveStatement)) continue;
            builder.setRequireInstance(((Boolean)((RequireInstanceEffectiveStatement)subStmt).argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl((TypeStatement.InstanceIdentifierSpecification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }
}

