/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractInternedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class PositionStatementSupport
extends AbstractInternedStatementSupport<Uint32, PositionStatement, PositionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.POSITION).build();

    public PositionStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.POSITION, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Uint32 parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Uint32.valueOf((String)value).intern();
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Bit position value %s is not valid integer", new Object[]{value});
        }
    }

    protected PositionStatement createDeclared(Uint32 argument, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createPosition((Uint32)argument, substatements);
    }

    protected PositionStatement createEmptyDeclared(Uint32 argument) {
        return DeclaredStatements.createPosition((Uint32)argument, (ImmutableList)ImmutableList.of());
    }

    protected PositionStatement attachDeclarationReference(PositionStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decoratePosition((PositionStatement)stmt, (DeclarationReference)reference);
    }

    protected PositionEffectiveStatement createEffective(PositionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createPosition((PositionStatement)declared, substatements);
    }

    protected PositionEffectiveStatement createEmptyEffective(PositionStatement declared) {
        return EffectiveStatements.createPosition((PositionStatement)declared);
    }
}

