/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class ContainerStatementSupport
extends AbstractSchemaTreeStatementSupport<ContainerStatement, ContainerEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.CONTAINER).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.PRESENCE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.CONTAINER).addAny((StatementDefinition)YangStmtMapping.ACTION).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.NOTIFICATION).addOptional((StatementDefinition)YangStmtMapping.PRESENCE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    private ContainerStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.CONTAINER, ContainerStatementSupport.instantiatedPolicy(), config, validator);
    }

    public static @NonNull ContainerStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new ContainerStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull ContainerStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new ContainerStatementSupport(config, RFC7950_VALIDATOR);
    }

    protected ContainerStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createContainer((QName)((QName)ctx.getArgument()), substatements);
    }

    protected ContainerStatement attachDeclarationReference(ContainerStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateContainer((ContainerStatement)stmt, (DeclarationReference)reference);
    }

    protected ContainerEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, ContainerStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        EffectiveStmtUtils.checkUniqueGroupings(stmt, substatements);
        EffectiveStmtUtils.checkUniqueTypedefs(stmt, substatements);
        EffectiveStmtUtils.checkUniqueUses(stmt, substatements);
        try {
            return EffectiveStatements.createContainer((ContainerStatement)((ContainerStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)ContainerStatementSupport.createFlags(stmt, substatements), substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public ContainerEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, ContainerStatement> stmt, ContainerEffectiveStatement original) {
        return EffectiveStatements.copyContainer((ContainerEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)ContainerStatementSupport.createFlags(stmt, original.effectiveSubstatements()));
    }

    public EffectiveStatementState extractEffectiveState(ContainerEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof ContainerSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        ContainerSchemaNode schema = (ContainerSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setPresence(schema.isPresenceContainer()).toFlags());
    }

    private static int createFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)ContainerStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setPresence(ContainerStatementSupport.findFirstStatement(substatements, PresenceEffectiveStatement.class) != null).toFlags();
    }
}

