/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import java.util.Collection;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.UndeclaredStmtCtx;

final class ImplicitStmtCtx<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends UndeclaredStmtCtx<A, D, E> {
    private boolean checkedSubstatement;

    ImplicitStmtCtx(StatementContextBase<?, ?, ?> parent, StatementSupport<A, D, E> support, String rawArgument) {
        super(parent, support, rawArgument);
    }

    @Override
    public boolean isSupportedToBuildEffective() {
        if (!this.checkedSubstatement) {
            Collection substatements = this.effectiveSubstatements();
            Verify.verify((!substatements.isEmpty() ? 1 : 0) != 0, (String)"Unexpected empty substatements in %s", (Object)this);
            StmtContext substatement = (StmtContext)substatements.iterator().next();
            if (!substatement.isSupportedToBuildEffective() || !substatement.isSupportedByFeatures()) {
                this.setUnsupported();
            }
            this.checkedSubstatement = true;
        }
        return super.isSupportedToBuildEffective();
    }
}

