/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReplicaStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InferredStatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E>
implements NamespaceBehaviour.OnDemandSchemaTreeStorageNode {
    private static final Logger LOG = LoggerFactory.getLogger(InferredStatementContext.class);
    private static final @NonNull String REUSED_SUBSTATEMENTS = "reused";
    private static final @NonNull String SWEPT_SUBSTATEMENTS = "swept";
    private final @NonNull StatementContextBase<A, D, E> prototype;
    private final @NonNull StatementContextBase<?, ?, ?> parent;
    private final @NonNull ReactorStmtCtx<A, D, E> originalCtx;
    private final QNameModule targetModule;
    private final A argument;
    private boolean modified;
    private Object substatements;

    private InferredStatementContext(InferredStatementContext<A, D, E> original, StatementContextBase<?, ?, ?> parent) {
        super(original);
        this.parent = Objects.requireNonNull(parent);
        this.targetModule = original.targetModule;
        this.prototype = original.prototype;
        this.originalCtx = original.originalCtx;
        this.argument = original.argument;
        this.modified = original.modified;
        this.substatements = ImmutableList.of();
    }

    InferredStatementContext(StatementContextBase<?, ?, ?> parent, StatementContextBase<A, D, E> prototype, CopyType myCopyType, CopyType childCopyType, QNameModule targetModule) {
        super(prototype, myCopyType, childCopyType);
        this.parent = Objects.requireNonNull(parent);
        this.prototype = Objects.requireNonNull(prototype);
        this.argument = targetModule == null ? prototype.argument() : prototype.definition().adaptArgumentValue((StmtContext<A, D, E>)prototype, targetModule);
        this.targetModule = targetModule;
        StmtContext origCtx = (StmtContext)prototype.getOriginalCtx().orElse(prototype);
        Verify.verify((boolean)(origCtx instanceof ReactorStmtCtx), (String)"Unexpected original %s", (Object)origCtx);
        this.originalCtx = (ReactorStmtCtx)origCtx;
        prototype.incRef();
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return ImmutableList.of();
    }

    public Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableEffectiveSubstatements() {
        return InferredStatementContext.mutableEffectiveSubstatements(this.ensureEffectiveSubstatements());
    }

    public Iterable<? extends @NonNull StmtContext<?, ?, ?>> allSubstatements() {
        return this.effectiveSubstatements();
    }

    public Stream<? extends @NonNull StmtContext<?, ?, ?>> allSubstatementsStream() {
        return this.effectiveSubstatements().stream();
    }

    public StatementSourceReference sourceReference() {
        return this.originalCtx.sourceReference();
    }

    public String rawArgument() {
        return this.originalCtx.rawArgument();
    }

    public Optional<StmtContext<A, D, E>> getOriginalCtx() {
        return Optional.of(this.originalCtx);
    }

    public Optional<StmtContext<A, D, E>> getPreviousCopyCtx() {
        return Optional.of(this.prototype);
    }

    public D declared() {
        return (D)this.originalCtx.declared();
    }

    public void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef) {
        this.substatements = InferredStatementContext.removeStatementFromEffectiveSubstatements(this.ensureEffectiveSubstatements(), statementDef);
    }

    public void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef, String statementArg) {
        this.substatements = InferredStatementContext.removeStatementFromEffectiveSubstatements(this.ensureEffectiveSubstatements(), statementDef, statementArg);
    }

    public void addEffectiveSubstatement(StmtContext.Mutable<?, ?, ?> substatement) {
        this.substatements = this.addEffectiveSubstatement(this.ensureEffectiveSubstatements(), substatement);
        InferredStatementContext.afterAddEffectiveSubstatement(substatement);
    }

    @Override
    void addEffectiveSubstatementsImpl(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        this.substatements = this.addEffectiveSubstatementsImpl(this.ensureEffectiveSubstatements(), statements);
    }

    @Override
    InferredStatementContext<A, D, E> reparent(StatementContextBase<?, ?, ?> newParent) {
        return new InferredStatementContext<A, D, E>(this, newParent);
    }

    @Override
    E createEffective(StatementFactory<A, D, E> factory) {
        this.accessSubstatements();
        return this.substatements == null ? this.tryToReusePrototype(factory) : this.createInferredEffective(factory);
    }

    private @NonNull E createInferredEffective(@NonNull StatementFactory<A, D, E> factory) {
        return this.createInferredEffective(factory, this, this.streamDeclared(), this.streamEffective());
    }

    @Override
    E createInferredEffective(StatementFactory<A, D, E> factory, InferredStatementContext<A, D, E> ctx, Stream<? extends ReactorStmtCtx<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        return this.originalCtx.createInferredEffective(factory, ctx, declared, effective);
    }

    private @NonNull E tryToReusePrototype(@NonNull StatementFactory<A, D, E> factory) {
        Object origEffective = this.prototype.buildEffective();
        List origSubstatements = origEffective.effectiveSubstatements();
        if (!factory.canReuseCurrent((EffectiveStmtCtx.Current)this, this.prototype, (Collection)origSubstatements)) {
            return this.internAlongCopyAxis(factory, this.tryToReuseSubstatements(factory, origEffective));
        }
        if (origSubstatements.isEmpty()) {
            LOG.debug("Reusing empty: {}", origEffective);
            this.substatements = ImmutableList.of();
            this.prototype.decRef();
            return origEffective;
        }
        if (this.allSubstatementsContextIndependent()) {
            LOG.debug("Reusing context-independent: {}", origEffective);
            this.substatements = this.noRefs() ? REUSED_SUBSTATEMENTS : this.reusePrototypeReplicas();
            this.prototype.decRef();
            return origEffective;
        }
        List<EffectiveCopy> declCopy = this.effectiveCopy(this.prototype.streamDeclared());
        List<EffectiveCopy> effCopy = this.effectiveCopy(this.prototype.streamEffective());
        if (InferredStatementContext.allReused(declCopy) && InferredStatementContext.allReused(effCopy)) {
            LOG.debug("Reusing after substatement check: {}", origEffective);
            this.substatements = this.noRefs() ? REUSED_SUBSTATEMENTS : this.reusePrototypeReplicas(Streams.concat((Stream[])new Stream[]{declCopy.stream(), effCopy.stream()}).map(copy -> copy.toReusedChild(this)));
            this.prototype.decRef();
            return origEffective;
        }
        ImmutableList<ReactorStmtCtx<?, ?, ?>> declared = this.adoptSubstatements(declCopy);
        ImmutableList<ReactorStmtCtx<?, ?, ?>> effective = this.adoptSubstatements(effCopy);
        this.substatements = declared.isEmpty() ? effective : Streams.concat((Stream[])new Stream[]{declared.stream(), effective.stream()}).collect(ImmutableList.toImmutableList());
        this.prototype.decRef();
        return this.internAlongCopyAxis(factory, this.originalCtx.createInferredEffective(factory, this, declared.stream(), effective.stream()));
    }

    private @NonNull E tryToReuseSubstatements(@NonNull StatementFactory<A, D, E> factory, @NonNull E original) {
        if (this.allSubstatementsContextIndependent()) {
            LOG.debug("Reusing substatements of: {}", this.prototype);
            this.substatements = this.noRefs() ? REUSED_SUBSTATEMENTS : this.reusePrototypeReplicas();
            this.prototype.decRef();
            return (E)factory.copyEffective((EffectiveStmtCtx.Current)this, original);
        }
        E effective = this.createInferredEffective(factory);
        this.modified = false;
        if (InferredStatementContext.sameSubstatements(original.effectiveSubstatements(), effective)) {
            LOG.debug("Reusing unchanged substatements of: {}", this.prototype);
            return (E)factory.copyEffective((EffectiveStmtCtx.Current)this, original);
        }
        return effective;
    }

    private @NonNull E internAlongCopyAxis(StatementFactory<A, D, E> factory, @NonNull E stmt) {
        EffectiveStatementState state;
        if (!this.modified && (state = factory.extractEffectiveState(stmt)) != null) {
            return this.prototype.unmodifiedEffectiveSource().attachEffectiveCopy(state, stmt);
        }
        return stmt;
    }

    private List<ReactorStmtCtx<?, ?, ?>> reusePrototypeReplicas() {
        return this.reusePrototypeReplicas(Streams.concat((Stream[])new Stream[]{this.prototype.streamDeclared(), this.prototype.streamEffective()}));
    }

    private List<ReactorStmtCtx<?, ?, ?>> reusePrototypeReplicas(Stream<ReactorStmtCtx<?, ?, ?>> stream) {
        return stream.map(stmt -> {
            ReplicaStatementContext ret = stmt.replicaAsChildOf(this);
            ret.buildEffective();
            return ret;
        }).collect(Collectors.toUnmodifiableList());
    }

    private static boolean sameSubstatements(Collection<?> original, EffectiveStatement<?, ?> effective) {
        List copied = effective.effectiveSubstatements();
        if (copied != effective.effectiveSubstatements() || original.size() != copied.size()) {
            return false;
        }
        Iterator cit = copied.iterator();
        for (Object origChild : original) {
            Verify.verify((boolean)cit.hasNext());
            if (origChild == cit.next()) continue;
            return false;
        }
        Verify.verify((!cit.hasNext() ? 1 : 0) != 0);
        return true;
    }

    private static boolean allReused(List<EffectiveCopy> entries) {
        return entries.stream().allMatch(EffectiveCopy::isReused);
    }

    @Override
    ReactorStmtCtx<A, D, E> unmodifiedEffectiveSource() {
        return this.modified ? this : this.prototype.unmodifiedEffectiveSource();
    }

    @Override
    boolean hasEmptySubstatements() {
        if (this.substatements == null) {
            return this.prototype.hasEmptySubstatements();
        }
        return this.substatements instanceof HashMap ? false : ((List)this.substatements).isEmpty();
    }

    @Override
    boolean noSensitiveSubstatements() {
        this.accessSubstatements();
        if (this.substatements == null) {
            return this.prototype.allSubstatementsContextIndependent();
        }
        if (this.substatements instanceof List) {
            return InferredStatementContext.noSensitiveSubstatements(InferredStatementContext.castEffective(this.substatements));
        }
        return this.prototype.allSubstatementsContextIndependent() && InferredStatementContext.noSensitiveSubstatements(InferredStatementContext.castMaterialized(this.substatements).values());
    }

    @Override
    <X, Z extends EffectiveStatement<X, ?>> @NonNull Optional<X> findSubstatementArgumentImpl(@NonNull Class<Z> type) {
        if (this.substatements instanceof List) {
            return super.findSubstatementArgumentImpl(type);
        }
        Optional templateArg = this.prototype.findSubstatementArgument(type);
        if (templateArg.isEmpty()) {
            return templateArg;
        }
        if (SchemaTreeEffectiveStatement.class.isAssignableFrom(type)) {
            return templateArg.map(template -> ((QName)template).bindTo(this.targetModule));
        }
        return templateArg;
    }

    @Override
    boolean hasSubstatementImpl(@NonNull Class<? extends EffectiveStatement<?, ?>> type) {
        return this.substatements instanceof List ? super.hasSubstatementImpl(type) : this.prototype.hasSubstatement(type);
    }

    public <Y extends DeclaredStatement<QName>, Z extends SchemaTreeEffectiveStatement<Y>> StmtContext<QName, Y, Z> requestSchemaTreeChild(QName qname) {
        if (this.substatements instanceof List) {
            return null;
        }
        QName templateQName = qname.bindTo(StmtContextUtils.getRootModuleQName(this.prototype));
        LOG.debug("Materializing child {} from {}", (Object)qname, (Object)templateQName);
        StmtContext template = this.prototype instanceof InferredStatementContext ? (StmtContext)((InferredStatementContext)this.prototype).getFromNamespace(ParserNamespaces.schemaTree(), templateQName) : (StmtContext)this.prototype.allSubstatementsStream().filter(stmt -> stmt.producesEffective(SchemaTreeEffectiveStatement.class) && templateQName.equals(stmt.argument())).findAny().orElse(null);
        if (template == null) {
            LOG.debug("Child {} does not have a template", (Object)qname);
            return null;
        }
        StmtContext.Mutable ret = this.copySubstatement(template).orElseThrow(() -> new InferenceException((CommonStmtCtx)this, "Failed to materialize child %s template %s", new Object[]{qname, template}));
        this.addMaterialized(template, this.ensureCompletedPhase(ret));
        LOG.debug("Child {} materialized", (Object)qname);
        return ret;
    }

    private List<ReactorStmtCtx<?, ?, ?>> ensureEffectiveSubstatements() {
        this.accessSubstatements();
        return this.substatements instanceof List ? InferredStatementContext.castEffective(this.substatements) : this.initializeSubstatements();
    }

    @Override
    Iterator<ReactorStmtCtx<?, ?, ?>> effectiveChildrenToComplete() {
        if (this.substatements == null) {
            return Collections.emptyIterator();
        }
        this.accessSubstatements();
        if (this.substatements instanceof HashMap) {
            return InferredStatementContext.castMaterialized(this.substatements).values().iterator();
        }
        return InferredStatementContext.castEffective(this.substatements).iterator();
    }

    @Override
    Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamDeclared() {
        return Stream.empty();
    }

    @Override
    Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamEffective() {
        return this.ensureEffectiveSubstatements().stream().filter(StmtContext::isSupportedToBuildEffective);
    }

    private void accessSubstatements() {
        if (this.substatements instanceof String) {
            throw new VerifyException("Access to " + this.substatements + " substatements of " + this);
        }
    }

    @Override
    void markNoParentRef() {
        Object local = this.substatements;
        if (local != null) {
            InferredStatementContext.markNoParentRef(InferredStatementContext.castEffective(local));
        }
    }

    @Override
    int sweepSubstatements() {
        Object local = this.substatements;
        this.substatements = SWEPT_SUBSTATEMENTS;
        int count = 0;
        if (local instanceof List) {
            List<ReactorStmtCtx<?, ?, ?>> list = InferredStatementContext.castEffective(local);
            InferredStatementContext.sweep(list);
            count = InferredStatementContext.countUnswept(list);
        }
        return count;
    }

    private List<ReactorStmtCtx<?, ?, ?>> initializeSubstatements() {
        Collection<StatementContextBase<?, ?, ?>> declared = this.prototype.mutableDeclaredSubstatements();
        Collection effective = this.prototype.mutableEffectiveSubstatements();
        int expectedSize = declared.size() + effective.size();
        HashMap materializedSchemaTree = InferredStatementContext.castMaterialized(this.substatements);
        if (materializedSchemaTree == null) {
            materializedSchemaTree = Maps.newHashMapWithExpectedSize((int)expectedSize);
            this.substatements = materializedSchemaTree;
        }
        ArrayList buffer = new ArrayList(expectedSize);
        for (StatementContextBase<?, ?, ?> statementContextBase : declared) {
            if (!statementContextBase.isSupportedByFeatures()) continue;
            this.copySubstatement(statementContextBase, buffer, materializedSchemaTree);
        }
        for (StmtContext.Mutable mutable : effective) {
            this.copySubstatement(mutable, buffer, materializedSchemaTree);
        }
        List<ReactorStmtCtx<?, ?, ?>> ret = this.beforeAddEffectiveStatementUnsafe((List<ReactorStmtCtx<?, ?, ?>>)ImmutableList.of(), buffer.size());
        ret.addAll(buffer);
        this.substatements = ret;
        this.modified = true;
        this.prototype.decRef();
        return ret;
    }

    private ImmutableList<ReactorStmtCtx<?, ?, ?>> adoptSubstatements(List<EffectiveCopy> list) {
        return (ImmutableList)list.stream().map(copy -> copy.toChildContext(this)).collect(ImmutableList.toImmutableList());
    }

    private List<EffectiveCopy> effectiveCopy(Stream<? extends ReactorStmtCtx<?, ?, ?>> stream) {
        return stream.map(this::effectiveCopy).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    private @Nullable EffectiveCopy effectiveCopy(ReactorStmtCtx<?, ?, ?> template) {
        ReactorStmtCtx<?, ?, ?> copy;
        if (this.substatements instanceof HashMap && (copy = InferredStatementContext.castMaterialized(this.substatements).get(template)) != null) {
            return new EffectiveCopy(template, copy);
        }
        copy = template.asEffectiveChildOf(this, this.childCopyType(), this.targetModule);
        return copy == null ? null : new EffectiveCopy(template, copy);
    }

    private void copySubstatement(StmtContext.Mutable<?, ?, ?> substatement, Collection<ReactorStmtCtx<?, ?, ?>> buffer, Map<StmtContext<?, ?, ?>, ReactorStmtCtx<?, ?, ?>> materializedSchemaTree) {
        ReactorStmtCtx<?, ?, ?> materialized = InferredStatementContext.findMaterialized(materializedSchemaTree, substatement);
        if (materialized == null) {
            this.copySubstatement((StmtContext)substatement).ifPresent(copy -> {
                ReactorStmtCtx<?, ?, ?> cast = this.ensureCompletedPhase((StmtContext.Mutable<?, ?, ?>)copy);
                materializedSchemaTree.put((StmtContext<?, ?, ?>)substatement, cast);
                buffer.add(cast);
            });
        } else {
            buffer.add(materialized);
        }
    }

    private <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> Optional<StmtContext.Mutable<X, Y, Z>> copySubstatement(StmtContext<X, Y, Z> substatement) {
        return substatement.copyAsChildOf((StmtContext.Mutable)this, this.childCopyType(), this.targetModule);
    }

    private void addMaterialized(StmtContext<?, ?, ?> template, ReactorStmtCtx<?, ?, ?> copy) {
        HashMap<Object, Object> materializedSchemaTree;
        if (this.substatements == null) {
            materializedSchemaTree = new HashMap(4);
            this.substatements = materializedSchemaTree;
            this.modified = true;
        } else {
            Verify.verify((boolean)(this.substatements instanceof HashMap), (String)"Unexpected substatements %s", (Object)this.substatements);
            materializedSchemaTree = InferredStatementContext.castMaterialized(this.substatements);
        }
        ReactorStmtCtx<?, ?, ?> existing = materializedSchemaTree.put(template, copy);
        if (existing != null) {
            throw new VerifyException("Unexpected duplicate request for " + copy.argument() + " previous result was " + existing);
        }
    }

    private static @Nullable ReactorStmtCtx<?, ?, ?> findMaterialized(Map<StmtContext<?, ?, ?>, ReactorStmtCtx<?, ?, ?>> materializedSchemaTree, StmtContext<?, ?, ?> template) {
        return materializedSchemaTree == null ? null : materializedSchemaTree.get(template);
    }

    private static List<ReactorStmtCtx<?, ?, ?>> castEffective(Object substatements) {
        return (List)substatements;
    }

    private static HashMap<StmtContext<?, ?, ?>, ReactorStmtCtx<?, ?, ?>> castMaterialized(Object substatements) {
        return (HashMap)substatements;
    }

    public A argument() {
        return this.argument;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return this.parent;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentNamespaceStorage() {
        return this.parent;
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this.parent.getRoot();
    }

    public EffectiveStmtCtx.Parent.EffectiveConfig effectiveConfig() {
        return this.effectiveConfig(this.parent);
    }

    @Override
    protected boolean isIgnoringIfFeatures() {
        return this.isIgnoringIfFeatures(this.parent);
    }

    @Override
    protected boolean isIgnoringConfig() {
        return this.isIgnoringConfig(this.parent);
    }

    @Override
    public boolean isSupportedToBuildEffective() {
        boolean ret = super.isSupportedToBuildEffective();
        if (ret && !this.prototype.isSupportedToBuildEffective()) {
            this.setUnsupported();
            ret = false;
        }
        return ret;
    }

    @Override
    protected boolean isParentSupportedByFeatures() {
        return this.parent.isSupportedByFeatures();
    }

    private static final class EffectiveCopy
    implements Immutable {
        private final ReactorStmtCtx<?, ?, ?> orig;
        private final ReactorStmtCtx<?, ?, ?> copy;

        EffectiveCopy(ReactorStmtCtx<?, ?, ?> orig, ReactorStmtCtx<?, ?, ?> copy) {
            this.orig = Objects.requireNonNull(orig);
            this.copy = Objects.requireNonNull(copy);
        }

        boolean isReused() {
            return this.orig == this.copy;
        }

        ReactorStmtCtx<?, ?, ?> toChildContext(@NonNull InferredStatementContext<?, ?, ?> parent) {
            return this.isReused() ? this.orig.replicaAsChildOf((StatementContextBase<?, ?, ?>)parent) : this.copy;
        }

        ReactorStmtCtx<?, ?, ?> toReusedChild(@NonNull InferredStatementContext<?, ?, ?> parent) {
            Verify.verify((boolean)this.isReused(), (String)"Attempted to discard copy %s", this.copy);
            return this.orig.replicaAsChildOf((StatementContextBase<?, ?, ?>)parent);
        }
    }
}

