/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDeclaration;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceException;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangSourceRepresentation;
import org.opendaylight.yangtools.yang.model.spi.meta.StatementDeclarations;

@NonNullByDefault
public final class YangIRSource
implements YangSourceRepresentation {
    private final SourceIdentifier sourceId;
    private final IRStatement statement;
    private final @Nullable String symbolicName;

    public YangIRSource(SourceIdentifier sourceId, IRStatement statement, @Nullable String symbolicName) {
        String rootName;
        IRKeyword rootKeyword = statement.keyword();
        if (!(rootKeyword instanceof IRKeyword.Unqualified)) {
            throw new StatementSourceException((StatementSourceReference)YangIRSource.refOf(sourceId, statement), "Root statement has invalid keyword " + String.valueOf(rootKeyword));
        }
        switch (rootName = rootKeyword.identifier()) {
            case "module": 
            case "submodule": {
                break;
            }
            default: {
                throw new StatementSourceException((StatementSourceReference)YangIRSource.refOf(sourceId, statement), "Invalid root statement keyword " + rootName);
            }
        }
        if (statement.argument() == null) {
            throw new StatementSourceException((StatementSourceReference)YangIRSource.refOf(sourceId, statement), "Root statement does not have an argument");
        }
        this.sourceId = Objects.requireNonNull(sourceId);
        this.statement = statement;
        this.symbolicName = symbolicName;
    }

    public SourceIdentifier sourceId() {
        return this.sourceId;
    }

    public @Nullable String symbolicName() {
        return this.symbolicName;
    }

    public Class<YangIRSource> getType() {
        return YangIRSource.class;
    }

    public IRStatement statement() {
        return this.statement;
    }

    @Beta
    public static StatementDeclaration.InText refOf(SourceIdentifier source, IRStatement stmt) {
        return StatementDeclarations.inText(source.name().getLocalName(), stmt.startLine(), stmt.startColumn() + 1);
    }
}

