/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.AbstractEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractUndeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.SingletonNamespace;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;

abstract sealed class AbstractIndexedEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractEffectiveStatement<A, D>
permits AbstractDeclaredEffectiveStatement, AbstractUndeclaredEffectiveStatement {
    AbstractIndexedEffectiveStatement() {
    }

    public ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return ImmutableList.of();
    }

    protected static @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> createSchemaTreeNamespace(Collection<? extends EffectiveStatement<?, ?>> substatements) {
        LinkedHashMap schemaChildren = new LinkedHashMap();
        substatements.stream().filter(SchemaTreeEffectiveStatement.class::isInstance).forEach(child -> AbstractIndexedEffectiveStatement.putChild(schemaChildren, (SchemaTreeEffectiveStatement)child, "schema tree"));
        return schemaChildren;
    }

    protected static @NonNull Map<QName, DataTreeEffectiveStatement<?>> createDataTreeNamespace(Collection<SchemaTreeEffectiveStatement<?>> schemaTreeStatements, Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace) {
        LinkedHashMap dataChildren = new LinkedHashMap();
        boolean sameAsSchema = true;
        for (SchemaTreeEffectiveStatement<?> child : schemaTreeStatements) {
            if (AbstractIndexedEffectiveStatement.indexDataTree(dataChildren, child)) continue;
            sameAsSchema = false;
        }
        return sameAsSchema ? schemaTreeNamespace : AbstractIndexedEffectiveStatement.immutableNamespaceOf(dataChildren);
    }

    protected static <T extends SchemaTreeEffectiveStatement<?>> @NonNull Map<QName, T> immutableNamespaceOf(Map<QName, T> map) {
        return map.size() == 1 ? new SingletonNamespace((SchemaTreeEffectiveStatement)map.values().iterator().next()) : ImmutableMap.copyOf(map);
    }

    protected static @NonNull HashMap<QName, TypedefEffectiveStatement> createTypedefNamespace(Collection<? extends EffectiveStatement<?, ?>> substatements) {
        HashMap<QName, TypedefEffectiveStatement> typedefs = new HashMap<QName, TypedefEffectiveStatement>();
        substatements.stream().filter(TypedefEffectiveStatement.class::isInstance).forEach(child -> AbstractIndexedEffectiveStatement.putChild(typedefs, (TypedefEffectiveStatement)child, "typedef"));
        return typedefs;
    }

    private static boolean indexDataTree(Map<QName, DataTreeEffectiveStatement<?>> map, EffectiveStatement<?, ?> stmt) {
        block5: {
            block4: {
                if (stmt instanceof DataTreeEffectiveStatement) {
                    AbstractIndexedEffectiveStatement.putChild(map, (DataTreeEffectiveStatement)stmt, "data tree");
                    return true;
                }
                if (!(stmt instanceof ChoiceEffectiveStatement)) break block4;
                for (EffectiveStatement choiceChild : stmt.effectiveSubstatements()) {
                    if (!(choiceChild instanceof CaseEffectiveStatement)) continue;
                    for (EffectiveStatement caseChild : choiceChild.effectiveSubstatements()) {
                        AbstractIndexedEffectiveStatement.indexDataTree(map, caseChild);
                    }
                }
                break block5;
            }
            if (!(stmt instanceof CaseEffectiveStatement)) break block5;
            for (EffectiveStatement child : stmt.effectiveSubstatements()) {
                AbstractIndexedEffectiveStatement.indexDataTree(map, child);
            }
        }
        return false;
    }

    private static <A, E extends EffectiveStatement<A, ?>> void putChild(Map<A, E> map, E child, String namespace) {
        Object id = child.argument();
        EffectiveStatement prev = (EffectiveStatement)map.putIfAbsent(id, child);
        if (prev != null) {
            throw new SubstatementIndexingException("Cannot add " + namespace + " child with name " + String.valueOf(id) + ", a conflicting child already exists");
        }
    }
}

