/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.AbstractYangTextSource;

@NonNullByDefault
public class FileYangTextSource
extends AbstractYangTextSource<Path> {
    private final Charset charset;

    public FileYangTextSource(SourceIdentifier sourceId, Path path, Charset charset) {
        super(sourceId, path);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Supplied path " + path + " is not a regular file");
        }
        this.charset = Objects.requireNonNull(charset);
    }

    public FileYangTextSource(Path path) {
        this(SourceIdentifier.ofYangFileName((String)path.toFile().getName()), path, StandardCharsets.UTF_8);
    }

    public final Reader openStream() throws IOException {
        return new InputStreamReader(Files.newInputStream((Path)this.getDelegate(), new OpenOption[0]), this.charset);
    }

    public final @NonNull String symbolicName() {
        return ((Path)this.getDelegate()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("path", this.getDelegate());
    }
}

