/*
 * Copyright (c) 2019 PANTHEON.tech, s.r.o.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.yangtools.yang.model.spi;

import static java.util.Objects.requireNonNull;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.MoreObjects.ToStringHelper;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.PathExpression;

/**
 * Convenience base class for {@link PathExpression} implementations.
 */
@Beta
@NonNullByDefault
public abstract class AbstractPathExpression implements PathExpression {
    private final String originalString;

    protected AbstractPathExpression(final String originalString) {
        this.originalString = requireNonNull(originalString);
    }

    @Override
    public final String getOriginalString() {
        return originalString;
    }

    @Override
    public final String toString() {
        return addToStringAttributes(MoreObjects.toStringHelper(this).omitNullValues()).toString();
    }

    protected ToStringHelper addToStringAttributes(final ToStringHelper helper) {
        return helper.add("originalString", originalString);
    }
}
