/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveStatementInference;
import org.slf4j.LoggerFactory;

@Beta
@NonNullByDefault
public final class DefaultSchemaTreeInference
extends AbstractEffectiveStatementInference.WithPath<SchemaTreeEffectiveStatement<?>>
implements SchemaTreeInference {
    private static final String VERIFY_UNSAFE_PROP = "org.opendaylight.yangtools.yang.model.spi.DefaultSchemaTreeInference.verifyUnsafeOf";
    private static final boolean VERIFY_UNSAFE = Boolean.getBoolean("org.opendaylight.yangtools.yang.model.spi.DefaultSchemaTreeInference.verifyUnsafeOf");

    private DefaultSchemaTreeInference(EffectiveModelContext modelContext, ImmutableList<? extends SchemaTreeEffectiveStatement<?>> path) {
        super(modelContext, path);
    }

    public static DefaultSchemaTreeInference of(EffectiveModelContext modelContext, SchemaNodeIdentifier.Absolute path) {
        return new DefaultSchemaTreeInference(modelContext, (ImmutableList<? extends SchemaTreeEffectiveStatement<?>>)DefaultSchemaTreeInference.resolveSteps(modelContext, path.getNodeIdentifiers()));
    }

    public static DefaultSchemaTreeInference unsafeOf(EffectiveModelContext modelContext, ImmutableList<? extends SchemaTreeEffectiveStatement<?>> path) {
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
        return VERIFY_UNSAFE ? DefaultSchemaTreeInference.verifiedOf(modelContext, path) : new DefaultSchemaTreeInference(modelContext, path);
    }

    @VisibleForTesting
    static DefaultSchemaTreeInference verifiedOf(EffectiveModelContext modelContext, ImmutableList<? extends SchemaTreeEffectiveStatement<?>> path) {
        ImmutableList<SchemaTreeEffectiveStatement<?>> resolved = DefaultSchemaTreeInference.resolveSteps(modelContext, Lists.transform(path, ModelStatement::argument));
        Preconditions.checkArgument((boolean)path.equals(resolved), (String)"Provided path %s is not consistent with resolved path %s", path, resolved);
        return new DefaultSchemaTreeInference(modelContext, path);
    }

    private static ImmutableList<SchemaTreeEffectiveStatement<?>> resolveSteps(EffectiveModelContext modelContext, List<QName> steps) {
        QName first = steps.get(0);
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)modelContext.findModuleStatement(first.getModule()).orElseThrow(() -> new IllegalArgumentException("No module for " + first));
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)steps.size());
        ModuleEffectiveStatement parent = module;
        Iterator<QName> it = steps.iterator();
        while (true) {
            QName qname = it.next();
            SchemaTreeEffectiveStatement found = (SchemaTreeEffectiveStatement)parent.findSchemaTreeNode(qname).orElseThrow(() -> new IllegalArgumentException("Cannot resolve step " + qname + " in " + builder.build()));
            builder.add((Object)found);
            if (!it.hasNext()) break;
            Preconditions.checkArgument((boolean)(found instanceof SchemaTreeAwareEffectiveStatement), (String)"Cannot resolve steps %s past %s", steps, (Object)found);
            parent = (SchemaTreeAwareEffectiveStatement)found;
        }
        return builder.build();
    }

    static {
        if (VERIFY_UNSAFE) {
            LoggerFactory.getLogger(DefaultSchemaTreeInference.class).info("DefaultSchemaTreeInference.unsafeOf() arguments are being verified");
        }
    }
}

