/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public abstract class TypeBuilder<T extends TypeDefinition<T>>
implements Mutable {
    private final ImmutableList.Builder<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.builder();
    private final @NonNull QName qname;
    private final T baseType;

    TypeBuilder(T baseType, QName qname) {
        this.qname = Objects.requireNonNull(qname);
        this.baseType = baseType;
    }

    public abstract @NonNull T build();

    final T getBaseType() {
        return this.baseType;
    }

    final @NonNull QName getQName() {
        return this.qname;
    }

    final @NonNull Collection<? extends UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes.build();
    }

    public final void addUnknownSchemaNode(@NonNull UnknownSchemaNode node) {
        this.unknownSchemaNodes.add((Object)node);
    }
}

