/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.BaseDecimalType;
import org.opendaylight.yangtools.yang.model.ri.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.ResolvedRangeConstraint;

public final class DecimalTypeBuilder
extends RangeRestrictedTypeBuilder<DecimalTypeDefinition, Decimal64> {
    private Integer fractionDigits;

    DecimalTypeBuilder(QName qname) {
        super(null, qname);
    }

    public DecimalTypeBuilder setFractionDigits(int fractionDigits) {
        Preconditions.checkState((this.fractionDigits == null ? 1 : 0) != 0, (String)"Fraction digits already defined to %s", (Object)this.fractionDigits);
        this.fractionDigits = fractionDigits;
        return this;
    }

    @Override
    DecimalTypeDefinition buildConstrainedType(ConstraintMetaDefinition constraint, ImmutableList<ValueRange> ranges) {
        int scale = this.scale();
        return new BaseDecimalType(this.getQName(), this.getUnknownSchemaNodes(), scale, new ResolvedRangeConstraint<Decimal64>(constraint, DecimalTypeBuilder.ensureResolvedScale(this.calculateRanges(BaseDecimalType.constraintsForDigits(scale), ranges), scale)));
    }

    @Override
    DecimalTypeDefinition buildUnconstrainedType() {
        int scale = this.scale();
        return new BaseDecimalType(this.getQName(), this.getUnknownSchemaNodes(), scale, BaseDecimalType.constraintsForDigits(scale));
    }

    private int scale() {
        Integer local = this.fractionDigits;
        Preconditions.checkState((local != null ? 1 : 0) != 0, (Object)"Fraction digits not defined");
        return local;
    }

    private static @NonNull RangeSet<Decimal64> ensureResolvedScale(RangeSet<Decimal64> ranges, int scale) {
        Set rangeSet = ranges.asRanges();
        for (Range range : rangeSet) {
            if (((Decimal64)range.lowerEndpoint()).scale() == scale && ((Decimal64)range.upperEndpoint()).scale() == scale) continue;
            return DecimalTypeBuilder.resolveScale(rangeSet, scale);
        }
        return ranges;
    }

    private static @NonNull RangeSet<Decimal64> resolveScale(Set<Range<Decimal64>> ranges, int scale) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range range : ranges) {
            Decimal64 upper;
            boolean reuse = true;
            Decimal64 lower = (Decimal64)range.lowerEndpoint();
            if (lower.scale() != scale) {
                lower = lower.scaleTo(scale);
                reuse = false;
            }
            if ((upper = (Decimal64)range.upperEndpoint()).scale() != scale) {
                upper = upper.scaleTo(scale);
                reuse = false;
            }
            builder.add(reuse ? range : Range.closed((Comparable)lower, (Comparable)upper));
        }
        return builder.build();
    }
}

