/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

final class BitImpl
implements BitsTypeDefinition.Bit,
Immutable {
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final @NonNull String name;
    private final String description;
    private final String reference;
    private final @NonNull Status status;
    private final @NonNull Uint32 position;

    BitImpl(String name, Uint32 position, String description, String reference, Status status, List<UnknownSchemaNode> unknownNodes) {
        this.name = Objects.requireNonNull(name);
        this.position = Objects.requireNonNull(position);
        this.description = description;
        this.reference = reference;
        this.status = Objects.requireNonNull(status);
        this.unknownNodes = ImmutableList.copyOf(unknownNodes);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public Status getStatus() {
        return this.status;
    }

    public Collection<? extends UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public Uint32 getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.position.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitsTypeDefinition.Bit)) {
            return false;
        }
        BitsTypeDefinition.Bit other = (BitsTypeDefinition.Bit)obj;
        return this.name.equals(other.getName()) && this.position == other.getPosition();
    }

    public String toString() {
        return BitsTypeDefinition.Bit.class.getSimpleName() + "[name=" + this.name + ", position=" + String.valueOf(this.position) + "]";
    }
}

