/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;

abstract class AbstractConstraint<T extends Number>
implements ConstraintMetaDefinition {
    private final ConstraintMetaDefinition meta;
    private final Object ranges;

    AbstractConstraint(ConstraintMetaDefinition meta, RangeSet<T> ranges) {
        this.meta = Objects.requireNonNull(meta);
        Set tmp = ranges.asRanges();
        this.ranges = tmp.size() == 1 ? tmp.iterator().next() : ImmutableRangeSet.copyOf(ranges);
    }

    public final Optional<String> getDescription() {
        return this.meta.getDescription();
    }

    public final Optional<String> getErrorAppTag() {
        return this.meta.getErrorAppTag();
    }

    public final Optional<String> getErrorMessage() {
        return this.meta.getErrorMessage();
    }

    public final Optional<String> getReference() {
        return this.meta.getReference();
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ranges", this.ranges()).toString();
    }

    final @NonNull ImmutableRangeSet<T> ranges() {
        if (this.ranges instanceof ImmutableRangeSet) {
            return (ImmutableRangeSet)this.ranges;
        }
        Verify.verify((boolean)(this.ranges instanceof Range), (String)"Unexpected range object %s", (Object)this.ranges);
        return ImmutableRangeSet.of((Range)((Range)this.ranges));
    }
}

