/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedTypes;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypedefEffectiveStatementImpl
extends AbstractDeclaredEffectiveStatement.DefaultArgument.WithSubstatements<QName, TypedefStatement>
implements TypedefEffectiveStatement,
EffectiveStatementMixins.SchemaNodeMixin<TypedefStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(TypedefEffectiveStatementImpl.class);
    private static final VarHandle TYPE_DEFINITION;
    private static final VarHandle TYPE_STATEMENT;
    private final int flags;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile TypeDefinition<?> typeDefinition;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile ProxyTypeEffectiveStatement typeStatement;

    public TypedefEffectiveStatementImpl(TypedefStatement declared, int flags, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        super((DeclaredStatement)declared, substatements);
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    public TypeDefinition<?> getTypeDefinition() {
        TypeDefinition<?> existing = TYPE_DEFINITION.getAcquire(this);
        return existing != null ? existing : this.loadTypeDefinition();
    }

    public TypeEffectiveStatement<TypeStatement> asTypeEffectiveStatement() {
        ProxyTypeEffectiveStatement local = TYPE_STATEMENT.getAcquire(this);
        return local != null ? local : this.loadTypeStatement();
    }

    private @NonNull TypeDefinition<?> loadTypeDefinition() {
        TypeEffectiveStatement type = (TypeEffectiveStatement)this.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).orElseThrow();
        DerivedTypeBuilder<?> builder = DerivedTypes.derivedTypeBuilder(type.getTypeDefinition(), (QName)this.argument());
        this.effectiveSubstatements().forEach(stmt -> {
            EffectiveStatement effectiveStatement = stmt;
            Objects.requireNonNull(effectiveStatement);
            EffectiveStatement selector0$temp = effectiveStatement;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultEffectiveStatement.class, DescriptionEffectiveStatement.class, ReferenceEffectiveStatement.class, StatusEffectiveStatement.class, TypeEffectiveStatement.class, UnitsEffectiveStatement.class, UnknownSchemaNode.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    DefaultEffectiveStatement dflt = (DefaultEffectiveStatement)selector0$temp;
                    builder.setDefaultValue(dflt.argument());
                    break;
                }
                case 1: {
                    DescriptionEffectiveStatement description = (DescriptionEffectiveStatement)selector0$temp;
                    builder.setDescription((String)description.argument());
                    break;
                }
                case 2: {
                    ReferenceEffectiveStatement reference = (ReferenceEffectiveStatement)selector0$temp;
                    builder.setReference((String)reference.argument());
                    break;
                }
                case 3: {
                    StatusEffectiveStatement status = (StatusEffectiveStatement)selector0$temp;
                    builder.setStatus((Status)status.argument());
                    break;
                }
                case 4: {
                    TypeEffectiveStatement tef = (TypeEffectiveStatement)selector0$temp;
                    break;
                }
                case 5: {
                    UnitsEffectiveStatement units = (UnitsEffectiveStatement)selector0$temp;
                    builder.setUnits((String)units.argument());
                    break;
                }
                case 6: {
                    UnknownSchemaNode unknown = (UnknownSchemaNode)selector0$temp;
                    builder.addUnknownSchemaNode(unknown);
                    break;
                }
                default: {
                    LOG.debug("Ignoring statement {}", stmt);
                }
            }
        });
        Object created = builder.build();
        Object witness = TYPE_DEFINITION.compareAndExchangeRelease(this, null, (TypeDefinition)created);
        return witness == null ? created : (TypeDefinition)witness;
    }

    private @NonNull ProxyTypeEffectiveStatement loadTypeStatement() {
        ProxyTypeEffectiveStatement created = new ProxyTypeEffectiveStatement();
        Object witness = TYPE_STATEMENT.compareAndExchangeRelease(this, null, created);
        return witness == null ? created : (ProxyTypeEffectiveStatement)witness;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            TYPE_DEFINITION = lookup.findVarHandle(TypedefEffectiveStatementImpl.class, "typeDefinition", TypeDefinition.class);
            TYPE_STATEMENT = lookup.findVarHandle(TypedefEffectiveStatementImpl.class, "typeStatement", ProxyTypeEffectiveStatement.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private final class ProxyTypeEffectiveStatement
    implements TypeEffectiveStatement<TypeStatement> {
        private ProxyTypeEffectiveStatement() {
        }

        public TypeStatement getDeclared() {
            return null;
        }

        public ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return TypedefEffectiveStatementImpl.this.effectiveSubstatements();
        }

        public QName argument() {
            return (QName)TypedefEffectiveStatementImpl.this.argument();
        }

        public TypeDefinition<?> getTypeDefinition() {
            return TypedefEffectiveStatementImpl.this.getTypeDefinition();
        }
    }
}

