/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.export.YinXMLEventReaderFactory;

public final class YinExportUtils {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    private YinExportUtils() {
    }

    public static String wellFormedYinName(String name, Optional<Revision> revision) {
        return YinExportUtils.wellFormedYinName(name, revision.map(Revision::toString).orElse(null));
    }

    public static String wellFormedYinName(String name, String revision) {
        if (revision == null) {
            return name + ".yin";
        }
        return Objects.requireNonNull(name) + "@" + revision + ".yin";
    }

    public static void writeModuleAsYinText(ModuleEffectiveStatement module, OutputStream output) throws XMLStreamException {
        YinExportUtils.writeReaderToOutput(YinXMLEventReaderFactory.defaultInstance().createXMLEventReader(module), output);
    }

    public static void writeSubmoduleAsYinText(ModuleEffectiveStatement parentModule, SubmoduleEffectiveStatement submodule, OutputStream output) throws XMLStreamException {
        YinExportUtils.writeReaderToOutput(YinXMLEventReaderFactory.defaultInstance().createXMLEventReader(parentModule, submodule), output);
    }

    private static void writeReaderToOutput(XMLEventReader reader, OutputStream output) throws XMLStreamException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.transform(new StAXSource(reader), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new XMLStreamException("Failed to stream XML events", e);
        }
    }
}

