/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.export.StatementPrefixResolver;
import org.opendaylight.yangtools.yang.model.export.YangTextSnippetIterator;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class YangTextSnippet
implements Immutable,
Iterable<String> {
    private final Set<@NonNull StatementDefinition> ignoredStatements;
    private final StatementPrefixResolver resolver;
    private final DeclaredStatement<?> statement;
    private final boolean omitDefaultStatements;

    YangTextSnippet(DeclaredStatement<?> statement, StatementPrefixResolver resolver, Set<@NonNull StatementDefinition> ignoredStatements, boolean omitDefaultStatements) {
        this.statement = Objects.requireNonNull(statement);
        this.resolver = Objects.requireNonNull(resolver);
        this.ignoredStatements = Objects.requireNonNull(ignoredStatements);
        this.omitDefaultStatements = omitDefaultStatements;
    }

    @Override
    public Iterator<@NonNull String> iterator() {
        return new YangTextSnippetIterator(this.statement, this.resolver, this.ignoredStatements, this.omitDefaultStatements);
    }

    @Override
    public Spliterator<@NonNull String> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1296);
    }

    public Stream<@NonNull String> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static boolean isEolString(String str) {
        return !str.isEmpty() && str.charAt(str.length() - 1) == '\n';
    }

    public String toString() {
        return this.stream().collect(Collectors.joining());
    }
}

