/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RootEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;

final class StatementPrefixResolver {
    private final Map<QNameModule, ?> lookup;

    private StatementPrefixResolver(ImmutableMap<QNameModule, ?> map) {
        this.lookup = (Map)Objects.requireNonNull(map);
    }

    private StatementPrefixResolver(RootEffectiveStatement<?> stmt) {
        this.lookup = ImmutableMap.copyOf((Iterable)stmt.namespacePrefixes());
    }

    static StatementPrefixResolver forModule(ModuleEffectiveStatement module) {
        Collection submodules = module.submodules();
        if (submodules.isEmpty()) {
            return new StatementPrefixResolver((RootEffectiveStatement<?>)module);
        }
        HashMap prefixToNamespaces = new HashMap();
        StatementPrefixResolver.indexPrefixes(prefixToNamespaces, module);
        for (Object submodule : submodules) {
            StatementPrefixResolver.indexPrefixes(prefixToNamespaces, submodule);
        }
        HashMultimap namespaceToPrefixes = HashMultimap.create();
        for (Map.Entry entry : prefixToNamespaces.entrySet()) {
            for (QNameModule namespace : ((Multimap)entry.getValue()).keySet()) {
                namespaceToPrefixes.put((Object)namespace, (Object)((String)entry.getKey()));
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)prefixToNamespaces.size());
        Iterator<Map.Entry<String, Multimap<QNameModule, EffectiveStatement<?, ?>>>> iterator = prefixToNamespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            QNameModule namespace;
            Map.Entry<String, Multimap<QNameModule, EffectiveStatement<?, ?>>> entry = iterator.next();
            Multimap<QNameModule, EffectiveStatement<?, ?>> modules = entry.getValue();
            if (modules.size() != 1 || namespaceToPrefixes.get((Object)(namespace = (QNameModule)modules.keys().iterator().next())).size() != 1) continue;
            builder.put((Object)namespace, (Object)entry.getKey());
            iterator.remove();
        }
        if (!prefixToNamespaces.isEmpty()) {
            ArrayListMultimap conflicts = ArrayListMultimap.create();
            for (Map.Entry<String, Multimap<QNameModule, EffectiveStatement<?, ?>>> entry : prefixToNamespaces.entrySet()) {
                for (Map.Entry namespaceEntry : entry.getValue().entries()) {
                    conflicts.put((Object)((QNameModule)namespaceEntry.getKey()), new AbstractMap.SimpleImmutableEntry<DeclaredStatement, String>(((EffectiveStatement)namespaceEntry.getValue()).getDeclared(), entry.getKey()));
                }
            }
            builder.putAll(Maps.transformValues((Map)conflicts.asMap(), Conflict::new));
        }
        return new StatementPrefixResolver(builder.build());
    }

    static StatementPrefixResolver forSubmodule(SubmoduleEffectiveStatement submodule) {
        return new StatementPrefixResolver((RootEffectiveStatement<?>)submodule);
    }

    Optional<String> findPrefix(DeclaredStatement<?> stmt) {
        QNameModule module = stmt.statementDefinition().getStatementName().getModule();
        if (YangConstants.RFC6020_YIN_MODULE.equals((Object)module)) {
            return Optional.empty();
        }
        Object obj = this.lookup.get(module);
        if (obj != null) {
            return StatementPrefixResolver.decodeEntry(obj, stmt);
        }
        if (module.getRevision().isPresent()) {
            throw new IllegalArgumentException("Failed to find prefix for statement " + stmt);
        }
        Map.Entry<QNameModule, ?> match = null;
        for (Map.Entry<QNameModule, ?> entry : this.lookup.entrySet()) {
            QNameModule ns = entry.getKey();
            if (!module.equals((Object)ns.withoutRevision()) || match != null && Revision.compare((Optional)((QNameModule)match.getKey()).getRevision(), (Optional)ns.getRevision()) >= 0) continue;
            match = entry;
        }
        return match == null ? null : StatementPrefixResolver.decodeEntry(match.getValue(), stmt);
    }

    private static Optional<String> decodeEntry(Object entry, DeclaredStatement<?> stmt) {
        if (entry instanceof String) {
            String str = (String)entry;
            return Optional.of(str);
        }
        if (entry instanceof Conflict) {
            Conflict conflict = (Conflict)entry;
            String prefix = conflict.findPrefix(stmt);
            Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (String)"Failed to find prefix for statement %s", stmt);
            Verify.verify((!prefix.isEmpty() ? 1 : 0) != 0, (String)"Empty prefix for statement %s", stmt);
            return Optional.of(prefix);
        }
        throw new VerifyException("Unexpected entry " + entry);
    }

    private static void indexPrefixes(Map<String, Multimap<QNameModule, EffectiveStatement<?, ?>>> map, RootEffectiveStatement<?> stmt) {
        for (Map.Entry entry : stmt.namespacePrefixes()) {
            map.computeIfAbsent((String)entry.getValue(), key -> ArrayListMultimap.create()).put((Object)((QNameModule)entry.getKey()), stmt);
        }
    }

    private static final class Conflict {
        private final Collection<Map.Entry<DeclaredStatement<?>, String>> statements;

        Conflict(Collection<Map.Entry<DeclaredStatement<?>, String>> entries) {
            this.statements = Objects.requireNonNull(entries);
        }

        @Nullable String findPrefix(DeclaredStatement<?> stmt) {
            return this.statements.stream().filter(entry -> Conflict.contains((DeclaredStatement)entry.getKey(), stmt)).findFirst().map(Map.Entry::getValue).orElse(null);
        }

        private static boolean contains(DeclaredStatement<?> haystack, DeclaredStatement<?> needle) {
            if (haystack == needle) {
                return true;
            }
            for (DeclaredStatement child : haystack.declaredSubstatements()) {
                if (!Conflict.contains(child, needle)) continue;
                return true;
            }
            return false;
        }
    }
}

