/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

public abstract sealed class FeatureSet
implements Immutable {
    public static @NonNull FeatureSet of() {
        return Explicit.EMPTY;
    }

    public static @NonNull FeatureSet of(QName ... features) {
        return FeatureSet.of((ImmutableSet<QName>)ImmutableSet.copyOf((Object[])features));
    }

    public static @NonNull FeatureSet of(Set<QName> features) {
        return FeatureSet.of((ImmutableSet<QName>)ImmutableSet.copyOf(features));
    }

    private static @NonNull FeatureSet of(ImmutableSet<QName> features) {
        return features.isEmpty() ? FeatureSet.of() : new Explicit(features);
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public abstract boolean contains(@NonNull QName var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    private static final class Explicit
    extends FeatureSet {
        private static final @NonNull Explicit EMPTY = new Explicit((ImmutableSet<QName>)ImmutableSet.of());
        private final ImmutableSet<QName> features;

        Explicit(ImmutableSet<QName> features) {
            this.features = Objects.requireNonNull(features);
        }

        @Override
        public boolean contains(QName qname) {
            return this.features.contains((Object)qname);
        }

        @Override
        public int hashCode() {
            return this.features.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Explicit)) return false;
            Explicit other = (Explicit)obj;
            if (!this.features.equals(other.features)) return false;
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("features", this.features).toString();
        }
    }

    public static final class Builder {
        private final TreeMap<QNameModule, TreeSet<String>> moduleFeatures = new TreeMap();

        public @NonNull Builder addModuleFeatures(QNameModule module, Collection<String> names) {
            this.moduleFeatures.computeIfAbsent(module, ignored -> new TreeSet()).addAll(names);
            return this;
        }

        public @NonNull FeatureSet build() {
            return new Sparse(Maps.transformValues(this.moduleFeatures, ImmutableSet::copyOf));
        }
    }

    private static final class Sparse
    extends FeatureSet {
        private final ImmutableMap<QNameModule, ImmutableSet<String>> featuresByModule;

        Sparse(Map<QNameModule, ImmutableSet<String>> featuresByModule) {
            this.featuresByModule = ImmutableMap.copyOf(featuresByModule);
        }

        @Override
        public boolean contains(QName qname) {
            ImmutableSet sets = (ImmutableSet)this.featuresByModule.get((Object)qname.getModule());
            return sets == null || sets.contains((Object)qname.getLocalName());
        }

        @Override
        public int hashCode() {
            return this.featuresByModule.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Sparse)) return false;
            Sparse other = (Sparse)obj;
            if (!this.featuresByModule.equals(other.featuresByModule)) return false;
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("features", this.featuresByModule).toString();
        }
    }
}

