/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.VerifyException;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;

final class DefaultMethodHelpers {
    private DefaultMethodHelpers() {
    }

    static <E> @NonNull Optional<E> filterOptional(@NonNull Optional<?> optional, @NonNull Class<E> type) {
        return optional.filter(type::isInstance).map(type::cast);
    }

    static @NonNull InputEffectiveStatement verifyInputSubstatement(EffectiveStatement<?, ?> stmt) {
        return DefaultMethodHelpers.verifySubstatement(stmt, InputEffectiveStatement.class);
    }

    static @NonNull OutputEffectiveStatement verifyOutputSubstatement(EffectiveStatement<?, ?> stmt) {
        return DefaultMethodHelpers.verifySubstatement(stmt, OutputEffectiveStatement.class);
    }

    static @NonNull PrefixEffectiveStatement verifyPrefixSubstatement(EffectiveStatement<?, ?> stmt) {
        return DefaultMethodHelpers.verifySubstatement(stmt, PrefixEffectiveStatement.class);
    }

    static <T extends EffectiveStatement<?, ?>> @NonNull T verifySubstatement(EffectiveStatement<?, ?> stmt, Class<T> type) {
        return (T)((EffectiveStatement)stmt.findFirstEffectiveSubstatement(type).orElseThrow(() -> new VerifyException(String.valueOf(stmt) + " does not define a " + type.getSimpleName() + " substatement")));
    }
}

