/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public enum Status {
    CURRENT("current"),
    DEPRECATED("deprecated"),
    OBSOLETE("obsolete");

    private final String argument;

    private Status(String argument) {
        this.argument = Objects.requireNonNull(argument);
    }

    public String argument() {
        return this.argument;
    }

    public static @Nullable Status forArgument(String argument) {
        return switch (argument) {
            case "current" -> CURRENT;
            case "deprecated" -> DEPRECATED;
            case "obsolete" -> OBSOLETE;
            default -> null;
        };
    }

    public static Status ofArgument(String argument) {
        Status ret = Status.forArgument(argument);
        if (ret == null) {
            throw new IllegalArgumentException("\"" + argument + "\" is not a valid status statement argument");
        }
        return ret;
    }
}

