/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorException;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangIRSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToIRTransformer;
import org.opendaylight.yangtools.yang2sources.plugin.ContextHolder;
import org.opendaylight.yangtools.yang2sources.plugin.FileGeneratorArg;
import org.opendaylight.yangtools.yang2sources.plugin.FileGeneratorTaskFactory;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratedDirectories;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratorTask;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratorTaskFactory;
import org.opendaylight.yangtools.yang2sources.plugin.ProcessorModuleReactor;
import org.opendaylight.yangtools.yang2sources.plugin.ScannedDependency;
import org.opendaylight.yangtools.yang2sources.plugin.YangProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

class YangToSourcesProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YangToSourcesProcessor.class);
    private static final YangParserFactory DEFAULT_PARSER_FACTORY;
    static final String LOG_PREFIX = "yang-to-sources:";
    private static final String META_INF_STR = "META-INF";
    private static final String YANG_STR = "yang";
    static final String META_INF_YANG_STRING;
    static final String META_INF_YANG_STRING_JAR = "META-INF/yang";
    static final String META_INF_YANG_SERVICES_STRING_JAR = "META-INF/services";
    private final YangParserFactory parserFactory;
    private final File yangFilesRootDir;
    private final Set<File> excludedFiles;
    private final Map<String, FileGeneratorArg> fileGeneratorArgs;
    private final MavenProject project;
    private final boolean inspectDependencies;
    private final BuildContext buildContext;
    private final YangProvider yangProvider;

    private YangToSourcesProcessor(BuildContext buildContext, File yangFilesRootDir, Collection<File> excludedFiles, List<FileGeneratorArg> fileGeneratorsArgs, MavenProject project, boolean inspectDependencies, YangProvider yangProvider) {
        this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        this.yangFilesRootDir = Objects.requireNonNull(yangFilesRootDir, "yangFilesRootDir");
        this.excludedFiles = ImmutableSet.copyOf(excludedFiles);
        this.fileGeneratorArgs = Maps.uniqueIndex(fileGeneratorsArgs, FileGeneratorArg::getIdentifier);
        this.project = Objects.requireNonNull(project);
        this.inspectDependencies = inspectDependencies;
        this.yangProvider = Objects.requireNonNull(yangProvider);
        this.parserFactory = DEFAULT_PARSER_FACTORY;
    }

    @VisibleForTesting
    YangToSourcesProcessor(File yangFilesRootDir, Collection<File> excludedFiles, List<FileGeneratorArg> fileGenerators, MavenProject project, boolean inspectDependencies, YangProvider yangProvider) {
        this((BuildContext)new DefaultBuildContext(), yangFilesRootDir, excludedFiles, (List<FileGeneratorArg>)ImmutableList.of(), project, inspectDependencies, yangProvider);
    }

    YangToSourcesProcessor(BuildContext buildContext, File yangFilesRootDir, Collection<File> excludedFiles, List<FileGeneratorArg> fileGenerators, MavenProject project, boolean inspectDependencies) {
        this(buildContext, yangFilesRootDir, excludedFiles, fileGenerators, project, inspectDependencies, YangProvider.getInstance());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.conditionalExecute(false);
    }

    void conditionalExecute(boolean skip) throws MojoExecutionException, MojoFailureException {
        Stopwatch watch;
        Object dependencies;
        List<File> yangFilesInProject;
        try {
            yangFilesInProject = YangToSourcesProcessor.listFiles(this.yangFilesRootDir, this.excludedFiles);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to list project files", (Throwable)e);
        }
        if (yangFilesInProject.isEmpty()) {
            LOG.info("{} No input files found", (Object)LOG_PREFIX);
            return;
        }
        List<GeneratorTaskFactory> codeGenerators = this.instantiateGenerators();
        if (codeGenerators.isEmpty()) {
            LOG.warn("{} No code generators provided", (Object)LOG_PREFIX);
            return;
        }
        Set parserConfigs = codeGenerators.stream().map(GeneratorTaskFactory::parserConfig).collect(Collectors.toUnmodifiableSet());
        LOG.info("{} Inspecting {}", (Object)LOG_PREFIX, (Object)this.yangFilesRootDir);
        ArrayList<File> allFiles = new ArrayList<File>(yangFilesInProject);
        if (this.inspectDependencies) {
            dependencies = new ArrayList();
            watch = Stopwatch.createStarted();
            try {
                ScannedDependency.scanDependencies(this.project).forEach(arg_0 -> YangToSourcesProcessor.lambda$conditionalExecute$0(allFiles, (Collection)dependencies, arg_0));
            }
            catch (IOException e) {
                LOG.error("{} Failed to scan dependencies", (Object)LOG_PREFIX, (Object)e);
                throw new MojoExecutionException("yang-to-sources: Failed to scan dependencies ", (Exception)e);
            }
            LOG.info("{} Found {} dependencies in {}", new Object[]{LOG_PREFIX, dependencies.size(), watch});
        } else {
            dependencies = ImmutableList.of();
        }
        if (!allFiles.stream().anyMatch(arg_0 -> ((BuildContext)this.buildContext).hasDelta(arg_0))) {
            LOG.info("{} None of {} input files changed", (Object)LOG_PREFIX, (Object)allFiles.size());
            return;
        }
        watch = Stopwatch.createStarted();
        List<Map.Entry<YangTextSchemaSource, YangIRSchemaSource>> parsed = yangFilesInProject.parallelStream().map(file -> {
            YangTextSchemaSource textSource = YangTextSchemaSource.forPath((Path)file.toPath());
            try {
                return Map.entry(textSource, TextToIRTransformer.transformText((YangTextSchemaSource)textSource));
            }
            catch (IOException | YangSyntaxErrorException e) {
                throw new IllegalArgumentException("Failed to parse " + file, e);
            }
        }).collect(Collectors.toList());
        LOG.debug("Found project files: {}", yangFilesInProject);
        LOG.info("{} Project model files found: {} in {}", new Object[]{LOG_PREFIX, yangFilesInProject.size(), watch});
        ImmutableSet.Builder files = ImmutableSet.builder();
        for (YangParserConfiguration parserConfig : parserConfigs) {
            Optional<ProcessorModuleReactor> optReactor = this.createReactor(yangFilesInProject, parserConfig, (Collection<ScannedDependency>)dependencies, parsed);
            if (!optReactor.isPresent()) continue;
            ProcessorModuleReactor reactor = optReactor.orElseThrow();
            if (!skip) {
                ContextHolder holder;
                Stopwatch sw = Stopwatch.createStarted();
                try {
                    holder = reactor.toContext();
                }
                catch (YangParserException e) {
                    throw new MojoFailureException("Failed to process reactor " + reactor, (Throwable)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to read reactor " + reactor, (Exception)e);
                }
                LOG.info("{} {} YANG models processed in {}", new Object[]{LOG_PREFIX, holder.getContext().getModules().size(), sw});
                files.addAll(this.generateSources(holder, codeGenerators, parserConfig));
            } else {
                LOG.info("{} Skipping YANG code generation because property yang.skip is true", (Object)LOG_PREFIX);
            }
            Collection<YangTextSchemaSource> models = reactor.getModelsInProject();
            try {
                this.yangProvider.addYangsToMetaInf(this.project, models);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed write model files for " + models, (Exception)e);
            }
        }
        File generatedServicesDir = new GeneratedDirectories(this.project).getYangServicesDir();
        YangProvider.setResource(generatedServicesDir, this.project);
        LOG.debug("{} Yang services files from: {} marked as resources: {}", new Object[]{LOG_PREFIX, generatedServicesDir, META_INF_YANG_SERVICES_STRING_JAR});
    }

    private List<GeneratorTaskFactory> instantiateGenerators() throws MojoExecutionException {
        ImmutableMap factories = Maps.uniqueIndex(ServiceLoader.load(FileGeneratorFactory.class), FileGeneratorFactory::getIdentifier);
        ArrayList<GeneratorTaskFactory> generators = new ArrayList<GeneratorTaskFactory>(factories.size());
        for (Map.Entry entry : factories.entrySet()) {
            String id = (String)entry.getKey();
            FileGeneratorArg arg = this.fileGeneratorArgs.get(id);
            if (arg == null) {
                LOG.debug("{} No configuration for {}, using empty", (Object)LOG_PREFIX, (Object)id);
                arg = new FileGeneratorArg(id);
            }
            try {
                generators.add(FileGeneratorTaskFactory.of((FileGeneratorFactory)entry.getValue(), arg));
            }
            catch (FileGeneratorException e) {
                throw new MojoExecutionException("File generator " + id + " failed", (Exception)((Object)e));
            }
            LOG.info("{} Code generator {} instantiated", (Object)LOG_PREFIX, (Object)id);
        }
        this.fileGeneratorArgs.keySet().forEach(arg_0 -> YangToSourcesProcessor.lambda$instantiateGenerators$2((Map)factories, arg_0));
        return generators;
    }

    private Optional<ProcessorModuleReactor> createReactor(List<File> yangFilesInProject, YangParserConfiguration parserConfig, Collection<ScannedDependency> dependencies, List<Map.Entry<YangTextSchemaSource, YangIRSchemaSource>> parsed) throws MojoExecutionException {
        try {
            ArrayList<YangTextSchemaSource> sourcesInProject = new ArrayList<YangTextSchemaSource>(yangFilesInProject.size());
            YangParser parser = this.parserFactory.createParser(parserConfig);
            for (Map.Entry<YangTextSchemaSource, YangIRSchemaSource> entry : parsed) {
                YangTextSchemaSource textSource = entry.getKey();
                YangIRSchemaSource astSource = entry.getValue();
                parser.addSource((SchemaSourceRepresentation)astSource);
                if (!((SourceIdentifier)astSource.getIdentifier()).equals((Object)textSource.getIdentifier())) {
                    sourcesInProject.add(YangTextSchemaSource.delegateForByteSource((SourceIdentifier)((SourceIdentifier)astSource.getIdentifier()), (ByteSource)textSource));
                    continue;
                }
                sourcesInProject.add(textSource);
            }
            ProcessorModuleReactor reactor = new ProcessorModuleReactor(parser, sourcesInProject, dependencies);
            LOG.debug("Initialized reactor {} with {}", (Object)reactor, yangFilesInProject);
            return Optional.of(reactor);
        }
        catch (IOException | RuntimeException | YangSyntaxErrorException e) {
            LOG.error("{} Unable to parse YANG files from {}", new Object[]{LOG_PREFIX, this.yangFilesRootDir, e});
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            throw new MojoExecutionException("yang-to-sources: Unable to parse YANG files from " + this.yangFilesRootDir, rootCause);
        }
    }

    private static List<File> listFiles(File root, Collection<File> excludedFiles) throws IOException {
        if (!root.isDirectory()) {
            LOG.warn("{} YANG source directory {} not found. No code will be generated.", (Object)LOG_PREFIX, (Object)root);
            return ImmutableList.of();
        }
        return Files.walk(root.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).filter(f -> {
            if (excludedFiles.contains(f)) {
                LOG.info("{} YANG file excluded {}", (Object)LOG_PREFIX, f);
                return false;
            }
            return true;
        }).filter(f -> f.getName().endsWith(".yang")).collect(Collectors.toList());
    }

    private Set<File> generateSources(ContextHolder context, Collection<GeneratorTaskFactory> generators, YangParserConfiguration parserConfig) throws MojoFailureException {
        ImmutableSet.Builder allFiles = ImmutableSet.builder();
        for (GeneratorTaskFactory factory : generators) {
            int fileCount;
            Collection<File> files;
            if (!parserConfig.equals((Object)factory.parserConfig())) continue;
            Stopwatch sw = Stopwatch.createStarted();
            GeneratorTask<?> task = factory.createTask(this.project, context);
            LOG.debug("{} Task {} initialized in {}", new Object[]{LOG_PREFIX, task, sw});
            try {
                files = task.execute(this.buildContext);
            }
            catch (IOException | FileGeneratorException e) {
                throw new MojoFailureException("yang-to-sources: Generator " + factory + " failed", e);
            }
            LOG.debug("{} Sources generated by {}: {}", new Object[]{LOG_PREFIX, factory.generatorName(), files});
            if (files != null) {
                fileCount = files.size();
                allFiles.addAll(files);
            } else {
                fileCount = 0;
            }
            LOG.info("{} Sources generated by {}: {} in {}", new Object[]{LOG_PREFIX, factory.generatorName(), fileCount, sw});
        }
        return allFiles.build();
    }

    private static /* synthetic */ void lambda$instantiateGenerators$2(Map factories, String fileGenIdentifier) {
        if (!factories.containsKey(fileGenIdentifier)) {
            LOG.warn("{} No generator found for identifier {}", (Object)LOG_PREFIX, (Object)fileGenIdentifier);
        }
    }

    private static /* synthetic */ void lambda$conditionalExecute$0(Collection allFiles, Collection dependencies, ScannedDependency dep) {
        allFiles.add(dep.file());
        dependencies.add(dep);
    }

    static {
        Iterator<YangParserFactory> it = ServiceLoader.load(YangParserFactory.class).iterator();
        Preconditions.checkState((boolean)it.hasNext(), (Object)"Failed to find a YangParserFactory implementation");
        DEFAULT_PARSER_FACTORY = it.next();
        META_INF_YANG_STRING = META_INF_STR + File.separator + YANG_STR;
    }
}

