/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.ir;

import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.ir.StatementInput;

final class StatementInputV1
extends StatementInput {
    private final List<@NonNull IRKeyword> keywords = new ArrayList<IRKeyword>();
    private final List<@NonNull String> strings = new ArrayList<String>();

    StatementInputV1(DataInput in) {
        super(in);
    }

    @Override
    IRStatement readStatement() throws IOException {
        int header = this.in.readUnsignedByte();
        int locationBits = header & 3;
        return switch (locationBits) {
            case 1 -> {
                int startLine = this.in.readUnsignedShort();
                int startColumn = this.in.readUnsignedShort();
                yield new IRStatement.Z22(this.readKeyword(header), this.readArgument(header), startLine, startColumn);
            }
            case 2 -> {
                int value = this.in.readInt();
                yield new IRStatement.Z31(this.readKeyword(header), this.readArgument(header), value);
            }
            case 3 -> this.readStatement(header);
            default -> throw new IOException("Unhandled location " + Integer.toHexString(locationBits));
        };
    }

    private @NonNull IRStatement readStatement(int header) throws IOException {
        int startLine = this.in.readInt();
        int startColumn = this.in.readInt();
        IRKeyword keyword = this.readKeyword(header);
        IRArgument argument = this.readArgument(header);
        ImmutableList<IRStatement> statements = this.readSubstatements(header);
        return switch (statements.size()) {
            case 0 -> new IRStatement.Z44(keyword, argument, startLine, startColumn);
            case 1 -> new IRStatement.O44(keyword, argument, (IRStatement)statements.getFirst(), startLine, startColumn);
            default -> new IRStatement.L44(keyword, argument, statements, startLine, startColumn);
        };
    }

    private @NonNull IRKeyword readKeyword(int header) throws IOException {
        int keyBits = header & 0xE0;
        return switch (keyBits) {
            case 160 -> this.lookupKeyword(this.in.readUnsignedByte());
            case 192 -> this.lookupKeyword(this.in.readUnsignedShort());
            case 224 -> this.lookupKeyword(this.in.readInt());
            case 32 -> this.defineKeyword(IRKeyword.Qualified.of(this.readString(), this.readString()));
            case 0 -> this.defineKeyword(IRKeyword.Unqualified.of(this.readString()));
            default -> throw new IllegalStateException("Unhandled key " + Integer.toHexString(keyBits));
        };
    }

    private @NonNull IRKeyword lookupKeyword(int code) throws IOException {
        try {
            return this.keywords.get(code);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Failed to look up keyword", e);
        }
    }

    private @NonNull IRKeyword defineKeyword(@NonNull IRKeyword keyword) {
        this.keywords.add(keyword);
        return keyword;
    }

    private ImmutableList<IRStatement> readSubstatements(int header) throws IOException {
        int sizeBits = header & 0x18;
        return switch (sizeBits) {
            case 0 -> ImmutableList.of();
            case 8 -> this.readSubstatementList(this.in.readUnsignedByte());
            case 16 -> this.readSubstatementList(this.in.readUnsignedShort());
            case 24 -> this.readSubstatementList(this.in.readInt());
            default -> throw new IOException("Unhandled size " + Integer.toHexString(sizeBits));
        };
    }

    private ImmutableList<IRStatement> readSubstatementList(int size) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.readStatement());
        }
        return builder.build();
    }

    private @Nullable IRArgument readArgument(int header) throws IOException {
        if ((header & 4) == 0) {
            return null;
        }
        int argHeader = this.in.readUnsignedByte();
        int type = argHeader & 7;
        return switch (type) {
            case 1 -> IRArgument.identifier(this.readString(argHeader));
            case 2 -> IRArgument.doubleQuoted(this.readString(argHeader));
            case 3 -> IRArgument.singleQuoted(this.readString(argHeader));
            case 4 -> IRArgument.unquoted(this.readString(argHeader));
            case 5 -> this.readConcatenation(this.in.readUnsignedByte());
            case 6 -> this.readConcatenation(this.in.readUnsignedShort());
            case 7 -> this.readConcatenation(this.in.readInt());
            default -> throw new IOException("Unhandled argument " + Integer.toHexString(type));
        };
    }

    private @NonNull IRArgument.Single readSingleArgument() throws IOException {
        int argHeader = this.in.readUnsignedByte();
        int type = argHeader & 7;
        return switch (type) {
            case 1 -> IRArgument.identifier(this.readString(argHeader));
            case 2 -> IRArgument.doubleQuoted(this.readString(argHeader));
            case 3 -> IRArgument.singleQuoted(this.readString(argHeader));
            case 4 -> IRArgument.unquoted(this.readString(argHeader));
            default -> throw new IOException("Unhandled single argument " + Integer.toHexString(type));
        };
    }

    private @NonNull IRArgument readConcatenation(int count) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)count);
        for (int i = 0; i < count; ++i) {
            builder.add((Object)this.readSingleArgument());
        }
        return IRArgument.of((List<IRArgument.Single>)builder.build());
    }

    private @NonNull String readString() throws IOException {
        return this.readString(this.in.readUnsignedByte());
    }

    private @NonNull String readString(int header) throws IOException {
        int type = header & 0x70;
        return switch (type) {
            case 0 -> this.defineString(this.in.readUTF());
            case 16 -> this.defineString(this.readStringBytes(this.in.readUnsignedByte()));
            case 32 -> this.defineString(this.readStringBytes(this.in.readUnsignedShort()));
            case 48 -> this.defineString(this.readStringBytes(this.in.readInt()));
            case 64 -> this.defineString(this.readStringChars());
            case 80 -> this.lookupString(this.in.readUnsignedByte());
            case 96 -> this.lookupString(this.in.readUnsignedShort());
            case 112 -> this.lookupString(this.in.readInt());
            default -> throw new IOException("Unhandled string " + Integer.toHexString(type));
        };
    }

    private @NonNull String lookupString(int offset) throws IOException {
        try {
            return this.strings.get(offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Invalid String reference " + offset, e);
        }
    }

    private @NonNull String defineString(@NonNull String string) {
        this.strings.add(string);
        return string;
    }

    private @NonNull String readStringBytes(int size) throws IOException {
        if (size > 0) {
            byte[] bytes = new byte[size];
            this.in.readFully(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (size == 0) {
            return "";
        }
        throw new IOException("Invalid String bytes length " + size);
    }

    private @NonNull String readStringChars() throws IOException {
        int size = this.in.readInt();
        if (size > 0) {
            char[] chars = new char[size];
            for (int i = 0; i < size; ++i) {
                chars[i] = this.in.readChar();
            }
            return String.valueOf(chars);
        }
        if (size == 0) {
            return "";
        }
        throw new IOException("Invalid String chars length " + size);
    }
}

