/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;

public final class ContainerSchemaNodes {
    private ContainerSchemaNodes() {
    }

    @Beta
    public static ContainerLike forNotification(NotificationDefinition notification) {
        return new NotificationContainerSchemaNode(notification);
    }

    @Beta
    public static ContainerLike forRPC(RpcDefinition rpc) {
        return new RpcContainerSchemaNode(rpc);
    }

    private static final class NotificationContainerSchemaNode
    extends AbstractContainerSchemaNode {
        private final NotificationDefinition notification;
        private final ImmutableMap<QName, ? extends DataSchemaNode> mapNodes;

        private NotificationContainerSchemaNode(NotificationDefinition notification) {
            super((SchemaNode)notification);
            this.notification = notification;
            this.mapNodes = Maps.uniqueIndex((Iterable)notification.getChildNodes(), SchemaNode::getQName);
        }

        public Collection<? extends NotificationDefinition> getNotifications() {
            return ImmutableSet.of((Object)this.notification);
        }

        public Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
            return this.notification.getAvailableAugmentations();
        }

        public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
            return this.notification.getTypeDefinitions();
        }

        public Collection<? extends DataSchemaNode> getChildNodes() {
            return this.notification.getChildNodes();
        }

        public Collection<? extends GroupingDefinition> getGroupings() {
            return this.notification.getGroupings();
        }

        public DataSchemaNode dataChildByName(QName name) {
            return (DataSchemaNode)this.mapNodes.get((Object)Objects.requireNonNull(name));
        }

        @Deprecated(forRemoval=true)
        public boolean isAddedByUses() {
            return false;
        }

        public Collection<? extends ActionDefinition> getActions() {
            return ImmutableSet.of();
        }
    }

    private static final class RpcContainerSchemaNode
    extends AbstractContainerSchemaNode {
        private final RpcDefinition rpcDefinition;

        private RpcContainerSchemaNode(RpcDefinition rpcDefinition) {
            super((SchemaNode)rpcDefinition);
            this.rpcDefinition = rpcDefinition;
        }

        public Collection<? extends GroupingDefinition> getGroupings() {
            return this.rpcDefinition.getGroupings();
        }

        public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
            return this.rpcDefinition.getTypeDefinitions();
        }

        public Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
            return ImmutableSet.of();
        }

        public Collection<? extends DataSchemaNode> getChildNodes() {
            InputSchemaNode input = this.rpcDefinition.getInput();
            OutputSchemaNode output = this.rpcDefinition.getOutput();
            if (input == null && output == null) {
                return ImmutableList.of();
            }
            if (input != null && output != null) {
                return ImmutableList.of((Object)input, (Object)output);
            }
            if (input != null) {
                return ImmutableList.of((Object)input);
            }
            return ImmutableList.of((Object)output);
        }

        public DataSchemaNode dataChildByName(QName name) {
            return switch (name.getLocalName()) {
                case "input" -> this.rpcDefinition.getInput();
                case "output" -> this.rpcDefinition.getOutput();
                default -> null;
            };
        }

        @Deprecated(forRemoval=true)
        public boolean isAddedByUses() {
            return false;
        }

        public Collection<? extends ActionDefinition> getActions() {
            return ImmutableSet.of();
        }

        public Collection<? extends NotificationDefinition> getNotifications() {
            return ImmutableSet.of();
        }
    }

    private static abstract class AbstractContainerSchemaNode
    implements ContainerLike {
        private final SchemaNode schemaNode;

        private AbstractContainerSchemaNode(SchemaNode schemaNode) {
            this.schemaNode = schemaNode;
        }

        public Collection<? extends UsesNode> getUses() {
            return ImmutableSet.of();
        }

        @Deprecated
        public boolean isAugmenting() {
            return false;
        }

        public Optional<Boolean> effectiveConfig() {
            return Optional.empty();
        }

        public QName getQName() {
            return this.schemaNode.getQName();
        }

        public Optional<String> getDescription() {
            return this.schemaNode.getDescription();
        }

        public Optional<String> getReference() {
            return this.schemaNode.getReference();
        }

        public Status getStatus() {
            return this.schemaNode.getStatus();
        }

        public Collection<? extends @NonNull MustDefinition> getMustConstraints() {
            return ImmutableList.of();
        }

        public Optional<? extends YangXPathExpression.QualifiedBound> getWhenCondition() {
            return Optional.empty();
        }
    }
}

