/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.CreatedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DeletedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.ReplacedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.UnmodifiedDataTreeCandidateNode;

@Beta
public final class DataTreeCandidateNodes {
    private DataTreeCandidateNodes() {
    }

    public static @NonNull DataTreeCandidateNode unmodified(NormalizedNode node) {
        return UnmodifiedDataTreeCandidateNode.of(node);
    }

    public static @NonNull DataTreeCandidateNode written(NormalizedNode node) {
        return CreatedDataTreeCandidateNode.of(node);
    }

    public static @NonNull Collection<DataTreeCandidateNode> containerDelta(@Nullable DistinctNodeContainer<?, ?> oldData, @Nullable DistinctNodeContainer<?, ?> newData) {
        if (newData == null) {
            return oldData == null ? ImmutableList.of() : Collections2.transform((Collection)oldData.body(), DeletedDataTreeCandidateNode::of);
        }
        if (oldData == null) {
            return Collections2.transform((Collection)newData.body(), CreatedDataTreeCandidateNode::of);
        }
        ArrayList<DataTreeCandidateNode> result = new ArrayList<DataTreeCandidateNode>();
        DistinctNodeContainer<?, ?> oldCast = oldData;
        for (NormalizedNode child : newData.body()) {
            NormalizedNode oldChild = oldCast.childByArg(child.name());
            result.add(oldChild == null ? CreatedDataTreeCandidateNode.of(child) : ReplacedDataTreeCandidateNode.of(oldChild, child));
        }
        DistinctNodeContainer<?, ?> newCast = newData;
        for (NormalizedNode child : oldData.body()) {
            if (newCast.childByArg(child.name()) != null) continue;
            result.add(DeletedDataTreeCandidateNode.of(child));
        }
        return result;
    }

    public static @Nullable DataTreeCandidateNode containerDelta(@Nullable DistinctNodeContainer<?, ?> oldData, @Nullable DistinctNodeContainer<?, ?> newData, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.PathArgument child) {
        NormalizedNode newChild = DataTreeCandidateNodes.getChild(newData, child);
        NormalizedNode oldChild = DataTreeCandidateNodes.getChild(oldData, child);
        if (oldChild != null) {
            return newChild != null ? ReplacedDataTreeCandidateNode.of(oldChild, newChild) : DeletedDataTreeCandidateNode.of(oldChild);
        }
        return newChild != null ? CreatedDataTreeCandidateNode.of(newChild) : null;
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        ModificationType type = node.modificationType();
        switch (type) {
            case DELETE: {
                cursor.delete(node.name());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(node.name());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.childNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(node.name(), (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + String.valueOf(type));
            }
        }
    }

    public static void applyRootedNodeToCursor(DataTreeModificationCursor cursor, YangInstanceIdentifier rootPath, DataTreeCandidateNode node) {
        ModificationType type = node.modificationType();
        switch (type) {
            case DELETE: {
                cursor.delete(rootPath.getLastPathArgument());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(rootPath.getLastPathArgument());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.childNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(rootPath.getLastPathArgument(), (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + String.valueOf(type));
            }
        }
    }

    public static void applyRootToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        ModificationType type = node.modificationType();
        switch (type) {
            case DELETE: {
                throw new IllegalArgumentException("Can not delete root.");
            }
            case SUBTREE_MODIFIED: 
            case WRITE: {
                AbstractNodeIterator iterator = new RootNonExitingIterator(node.childNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + String.valueOf(type));
            }
        }
    }

    private static @Nullable NormalizedNode getChild(DistinctNodeContainer<?, ?> container, YangInstanceIdentifier.PathArgument identifier) {
        return container == null ? null : container.childByArg(identifier);
    }

    private static final class ExitingNodeIterator
    extends AbstractNodeIterator {
        private final AbstractNodeIterator parent;

        ExitingNodeIterator(AbstractNodeIterator parent, Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        AbstractNodeIterator getParent() {
            return this.parent;
        }

        @Override
        void exitNode(DataTreeModificationCursor cursor) {
            cursor.exit();
        }
    }

    private static abstract class AbstractNodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;

        AbstractNodeIterator(Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        final AbstractNodeIterator next(DataTreeModificationCursor cursor) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                ModificationType type = node.modificationType();
                switch (type) {
                    case DELETE: {
                        cursor.delete(node.name());
                        break;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        Collection children = node.childNodes();
                        if (children.isEmpty()) continue block6;
                        cursor.enter(node.name());
                        return new ExitingNodeIterator(this, children.iterator());
                    }
                    case UNMODIFIED: {
                        break;
                    }
                    case WRITE: {
                        cursor.write(node.name(), (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported modification " + String.valueOf(type));
                    }
                }
            }
            this.exitNode(cursor);
            return this.getParent();
        }

        abstract @Nullable AbstractNodeIterator getParent();

        abstract void exitNode(DataTreeModificationCursor var1);
    }

    private static final class RootNonExitingIterator
    extends AbstractNodeIterator {
        RootNonExitingIterator(Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
        }

        @Override
        void exitNode(DataTreeModificationCursor cursor) {
        }

        @Override
        AbstractNodeIterator getParent() {
            return null;
        }
    }
}

