/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

public abstract class AbstractDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final @NonNull ModificationType modificationType;

    protected AbstractDataTreeCandidateNode(ModificationType modificationType) {
        this.modificationType = Objects.requireNonNull(modificationType);
    }

    public final ModificationType modificationType() {
        return this.modificationType;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(DataTreeCandidateNode.class).add("modificationType", (Object)this.modificationType)).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);

    protected static final @NonNull Collection<DataTreeCandidateNode> childNodes(DistinctNodeContainer<?, ?> container, Function<NormalizedNode, DataTreeCandidateNode> function) {
        Collection body = container.body();
        return Collections2.transform((Collection)body, function);
    }

    protected static final @Nullable DataTreeCandidateNode modifiedChild(DistinctNodeContainer<?, ?> container, Function<NormalizedNode, DataTreeCandidateNode> function, YangInstanceIdentifier.PathArgument childName) {
        NormalizedNode child = container.childByArg(childName);
        return child != null ? (DataTreeCandidateNode)function.apply((Object)child) : null;
    }
}

