/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.AbstractDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;

final class RecursiveReplaceCandidateNode
extends AbstractDataTreeCandidateNode {
    private final DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode> oldData;

    RecursiveReplaceCandidateNode(DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode> oldData, DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode> newData) {
        super(newData);
        this.oldData = Objects.requireNonNull(oldData);
    }

    public ModificationType getModificationType() {
        return ModificationType.WRITE;
    }

    public Optional<NormalizedNode> getDataAfter() {
        return this.dataOptional();
    }

    public Optional<NormalizedNode> getDataBefore() {
        return Optional.of(this.oldData);
    }

    public Optional<DataTreeCandidateNode> getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        return DataTreeCandidateNodes.containerDelta(this.oldData, this.data(), identifier);
    }

    public Collection<DataTreeCandidateNode> getChildNodes() {
        return DataTreeCandidateNodes.containerDelta(this.oldData, this.data());
    }
}

