/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;

final class LeafRefContextBuilder
implements Mutable {
    private final Map<QName, LeafRefContext> referencingChildren = new HashMap<QName, LeafRefContext>();
    private final Map<QName, LeafRefContext> referencedByChildren = new HashMap<QName, LeafRefContext>();
    private final Map<QName, LeafRefContext> referencedByLeafRefCtx = new HashMap<QName, LeafRefContext>();
    private final QName currentNodeQName;
    private final ImmutableList<QName> currentNodePath;
    private final EffectiveModelContext modelContext;
    private LeafRefPath leafRefTargetPath = null;
    private LeafRefPath absoluteLeafRefTargetPath = null;
    private String leafRefTargetPathString = "";
    private boolean isReferencedBy = false;
    private boolean isReferencing = false;

    LeafRefContextBuilder(QName currentNodeQName, ImmutableList<QName> currentNodePath, EffectiveModelContext modelContext) {
        this.currentNodeQName = Objects.requireNonNull(currentNodeQName);
        this.currentNodePath = Objects.requireNonNull(currentNodePath);
        this.modelContext = Objects.requireNonNull(modelContext);
    }

    @NonNull LeafRefContext build() {
        LeafRefContext leafRefContext = new LeafRefContext(this);
        this.referencingChildren.clear();
        this.referencedByChildren.clear();
        this.referencedByLeafRefCtx.clear();
        return leafRefContext;
    }

    boolean isReferencedBy() {
        return this.isReferencedBy;
    }

    void setReferencedBy(boolean referencedBy) {
        this.isReferencedBy = referencedBy;
    }

    boolean isReferencing() {
        return this.isReferencing;
    }

    void setReferencing(boolean referencing) {
        this.isReferencing = referencing;
    }

    void addReferencingChild(LeafRefContext child, QName childQName) {
        this.referencingChildren.put(childQName, child);
    }

    Map<QName, LeafRefContext> getReferencingChilds() {
        return this.referencingChildren;
    }

    void addReferencedByChild(LeafRefContext child, QName childQName) {
        this.referencedByChildren.put(childQName, child);
    }

    Map<QName, LeafRefContext> getReferencedByChilds() {
        return this.referencedByChildren;
    }

    ImmutableList<QName> getCurrentNodePath() {
        return this.currentNodePath;
    }

    LeafRefPath getLeafRefTargetPath() {
        return this.leafRefTargetPath;
    }

    void setLeafRefTargetPath(LeafRefPath leafRefPath) {
        this.leafRefTargetPath = Objects.requireNonNull(leafRefPath);
    }

    String getLeafRefTargetPathString() {
        return this.leafRefTargetPathString;
    }

    void setLeafRefTargetPathString(String leafRefPathString) {
        this.leafRefTargetPathString = Objects.requireNonNull(leafRefPathString);
    }

    QName getCurrentNodeQName() {
        return this.currentNodeQName;
    }

    EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    LeafRefPath getAbsoluteLeafRefTargetPath() {
        if (this.isReferencing && this.absoluteLeafRefTargetPath == null) {
            this.absoluteLeafRefTargetPath = this.leafRefTargetPath.isAbsolute() ? this.leafRefTargetPath : LeafRefUtils.createAbsoluteLeafRefPath(this.leafRefTargetPath, this.currentNodePath, this.getLeafRefContextModule());
        }
        return this.absoluteLeafRefTargetPath;
    }

    Module getLeafRefContextModule() {
        QNameModule qnameModule = this.currentNodePath.isEmpty() ? this.currentNodeQName.getModule() : ((QName)this.currentNodePath.get(0)).getModule();
        return this.modelContext.findModule(qnameModule).orElse(null);
    }

    void addReferencedByLeafRefCtx(QName qname, LeafRefContext leafRef) {
        this.referencedByLeafRefCtx.put(qname, leafRef);
    }

    LeafRefContext getReferencedByLeafRefCtxByName(QName qname) {
        return this.referencedByLeafRefCtx.get(qname);
    }

    Map<QName, LeafRefContext> getAllReferencedByLeafRefCtxs() {
        return this.referencedByLeafRefCtx;
    }
}

