/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.List;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangNetconfErrorAware;
import org.opendaylight.yangtools.yang.data.tree.api.RequiredElementCountException;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;

final class MinMaxElementsValidationFailedException
extends SchemaValidationFailedException
implements YangNetconfErrorAware {
    private static final long serialVersionUID = 1L;
    private final int min;
    private final int max;
    private final int actual;

    MinMaxElementsValidationFailedException(String message, int min, int max, int actual) {
        super(message);
        this.min = min;
        this.max = max;
        this.actual = actual;
    }

    public List<YangNetconfError> getNetconfErrors() {
        return new RequiredElementCountException(YangInstanceIdentifier.of(), this.actual, this.min, this.max, "dummy").getNetconfErrors();
    }
}

