/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.tree.impl.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class ContainerModificationStrategy
extends DataNodeContainerModificationStrategy<ContainerLike> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, ContainerNode> SUPPORT = new NormalizedNodeContainerSupport(ContainerNode.class, arg_0 -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newContainerBuilder(arg_0), () -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newContainerBuilder());

    ContainerModificationStrategy(ContainerLike schemaNode, DataTreeConfiguration treeConfig) {
        super(SUPPORT, schemaNode, treeConfig);
    }

    static ContainerModificationStrategy of(ContainerSchemaNode schema, DataTreeConfiguration treeConfig) {
        if (schema.isPresenceContainer()) {
            MandatoryLeafEnforcer enforcer = ContainerModificationStrategy.enforcerFor((DataSchemaNode)schema, treeConfig);
            return enforcer != null ? new EnforcingMandatory(schema, treeConfig, enforcer) : new ContainerModificationStrategy((ContainerLike)schema, treeConfig);
        }
        return new Structural((ContainerLike)schema, treeConfig);
    }

    static final class EnforcingMandatory
    extends ContainerModificationStrategy {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ContainerSchemaNode schemaNode, DataTreeConfiguration treeConfig, MandatoryLeafEnforcer enforcer) {
            super((ContainerLike)schemaNode, treeConfig);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void mandatoryVerifyValueChildren(DistinctNodeContainer<?, ?> writtenValue) {
            this.enforcer.enforceOnData(writtenValue);
        }

        @Override
        protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
            return this.enforce(super.applyMerge(modification, currentMeta, version));
        }

        @Override
        protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, TreeNode currentMeta, Version version) {
            return this.enforce(super.applyWrite(modification, newValue, currentMeta, version));
        }

        @Override
        protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
            return this.enforce(super.applyTouch(modification, currentMeta, version));
        }

        private @NonNull TreeNode enforce(TreeNode treeNode) {
            this.enforcer.enforceOnData(treeNode.getData());
            return treeNode;
        }
    }

    static final class Structural
    extends ContainerModificationStrategy {
        private final ContainerNode emptyNode;

        Structural(ContainerLike schema, DataTreeConfiguration treeConfig) {
            super(schema, treeConfig);
            this.emptyNode = (ContainerNode)BUILDER_FACTORY.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName())).build();
        }

        @Override
        TreeNode apply(ModifiedNode modification, TreeNode currentMeta, Version version) {
            return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, (NormalizedNode)this.emptyNode, modification, currentMeta, version);
        }

        @Override
        TreeNode defaultTreeNode() {
            return Structural.defaultTreeNode((NormalizedNode)this.emptyNode);
        }
    }
}

