/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeSnapshot;

final class InMemoryDataTreeSnapshotCursor
extends AbstractCursor<InMemoryDataTreeSnapshot> {
    private final Deque<DistinctNodeContainer<?, ?>> stack = new ArrayDeque();

    InMemoryDataTreeSnapshotCursor(InMemoryDataTreeSnapshot parent, YangInstanceIdentifier rootPath, DistinctNodeContainer<?, ?> normalizedNode) {
        super(parent, rootPath);
        this.stack.push(normalizedNode);
    }

    public void enter(YangInstanceIdentifier.PathArgument child) {
        Optional maybeChildNode = NormalizedNodes.getDirectChild((NormalizedNode)((NormalizedNode)this.stack.peek()), (YangInstanceIdentifier.PathArgument)child);
        Preconditions.checkArgument((boolean)maybeChildNode.isPresent(), (String)"Child %s not found", (Object)child);
        NormalizedNode childNode = (NormalizedNode)maybeChildNode.get();
        Preconditions.checkArgument((boolean)(childNode instanceof NormalizedNodeContainer), (String)"Child %s is not a container", (Object)child);
        this.stack.push((DistinctNodeContainer)childNode);
    }

    public void enter(Iterable<YangInstanceIdentifier.PathArgument> path) {
        Optional maybeChildNode = NormalizedNodes.findNode((NormalizedNode)((NormalizedNode)this.stack.peek()), path);
        Preconditions.checkArgument((boolean)maybeChildNode.isPresent(), (String)"Child %s not found", path);
        NormalizedNode childNode = (NormalizedNode)maybeChildNode.get();
        Preconditions.checkArgument((boolean)(childNode instanceof NormalizedNodeContainer), (String)"Child %s is not a container", path);
        int depth = 0;
        for (YangInstanceIdentifier.PathArgument arg : path) {
            try {
                this.enter(arg);
            }
            catch (Exception e) {
                for (int i = 0; i < depth; ++i) {
                    this.stack.pop();
                }
                throw new IllegalArgumentException(e);
            }
            ++depth;
        }
    }

    public void exit(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((depth < this.stack.size() ? 1 : 0) != 0);
        for (int i = 0; i < depth; ++i) {
            this.stack.pop();
        }
    }

    public Optional<NormalizedNode> readNode(YangInstanceIdentifier.PathArgument child) {
        return NormalizedNodes.findNode((NormalizedNode)((NormalizedNode)this.stack.peek()), (YangInstanceIdentifier.PathArgument)child);
    }
}

