/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractModifiedNodeBasedCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;

final class InMemoryDataTreeCandidate
extends AbstractDataTreeCandidate {
    private final RootNode root;

    InMemoryDataTreeCandidate(YangInstanceIdentifier rootPath, ModifiedNode modificationRoot, TreeNode beforeRoot, TreeNode afterRoot) {
        super(rootPath);
        this.root = new RootNode(modificationRoot, beforeRoot, afterRoot);
    }

    @Override
    protected TreeNode getTipRoot() {
        return this.root.getNewMeta();
    }

    TreeNode getBeforeRoot() {
        return this.root.getOldMeta();
    }

    public DataTreeCandidateNode getRootNode() {
        return this.root;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rootPath", (Object)this.getRootPath()).add("rootNode", (Object)this.getRootNode()).toString();
    }

    private static final class RootNode
    extends AbstractModifiedNodeBasedCandidateNode {
        RootNode(ModifiedNode mod, TreeNode oldMeta, TreeNode newMeta) {
            super(mod, oldMeta, newMeta);
        }

        public YangInstanceIdentifier.PathArgument getIdentifier() {
            throw new IllegalStateException("Attempted to get identifier of the root node");
        }
    }
}

