/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ExcludedDataSchemaNodeException;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataNodeContainerModificationStrategy<T extends DataNodeContainer & DocumentedNode.WithStatus>
extends AbstractNodeContainerModificationStrategy.Visible<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DataNodeContainerModificationStrategy.class);
    private static final VarHandle CHILDREN;
    private final @NonNull DataTreeConfiguration treeConfig;
    private volatile ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> children = ImmutableMap.of();

    DataNodeContainerModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, T schema, DataTreeConfiguration treeConfig) {
        super(support, treeConfig, schema);
        this.treeConfig = Objects.requireNonNull(treeConfig, "treeConfig");
    }

    @Override
    public final ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        ImmutableMap local = CHILDREN.getAcquire(this);
        ModificationApplyOperation existing = (ModificationApplyOperation)local.get((Object)arg);
        if (existing != null) {
            return existing;
        }
        ModificationApplyOperation childOperation = this.resolveChild(arg);
        return childOperation != null ? this.appendChild((ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation>)local, arg, childOperation) : null;
    }

    private ModificationApplyOperation resolveChild(YangInstanceIdentifier.PathArgument identifier) {
        QName qname;
        DataSchemaNode child;
        DataNodeContainer schema = (DataNodeContainer)this.getSchema();
        if (identifier instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            YangInstanceIdentifier.AugmentationIdentifier augId = (YangInstanceIdentifier.AugmentationIdentifier)identifier;
            if (schema instanceof AugmentationTarget) {
                AugmentationTarget augTarget = (AugmentationTarget)schema;
                return SchemaAwareApplyOperation.from(schema, augTarget, augId, this.treeConfig);
            }
        }
        if ((child = schema.dataChildByName(qname = identifier.getNodeType())) == null) {
            LOG.trace("Child {} not present in container schema {} children {}", new Object[]{identifier, this, schema.getChildNodes()});
            return null;
        }
        try {
            return SchemaAwareApplyOperation.from(child, this.treeConfig);
        }
        catch (ExcludedDataSchemaNodeException e) {
            LOG.trace("Failed to instantiate child {} in container schema {} children {}", new Object[]{identifier, this, schema.getChildNodes(), e});
            return null;
        }
    }

    private @Nullable ModificationApplyOperation appendChild(ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> initial, YangInstanceIdentifier.PathArgument identifier, ModificationApplyOperation computed) {
        ImmutableMap witness;
        ModificationApplyOperation raced;
        ImmutableMap previous = initial;
        do {
            ImmutableMap updated;
            if ((witness = CHILDREN.compareAndExchangeRelease(this, previous, updated = ImmutableMap.builderWithExpectedSize((int)(previous.size() + 1)).putAll(previous).put((Object)identifier, (Object)computed).build())) != previous) continue;
            return computed;
        } while ((raced = (ModificationApplyOperation)(previous = witness).get((Object)identifier)) == null);
        return raced;
    }

    static {
        try {
            CHILDREN = MethodHandles.lookup().findVarHandle(DataNodeContainerModificationStrategy.class, "children", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

