/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursorAware;

abstract class AbstractCursor<T extends AbstractCursorAware>
implements DataTreeSnapshotCursor {
    private static final VarHandle CLOSED;
    private final YangInstanceIdentifier rootPath;
    private final T parent;
    private volatile boolean closed;

    AbstractCursor(T parent, YangInstanceIdentifier rootPath) {
        this.rootPath = Objects.requireNonNull(rootPath);
        this.parent = (AbstractCursorAware)Objects.requireNonNull(parent);
    }

    final T getParent() {
        return this.parent;
    }

    final YangInstanceIdentifier getRootPath() {
        return this.rootPath;
    }

    final void ensureNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Modification cursor has been closed");
    }

    public final void enter(YangInstanceIdentifier.PathArgument ... path) {
        this.enter(Arrays.asList(path));
    }

    public final void exit() {
        this.exit(1);
    }

    public final void close() {
        if (CLOSED.compareAndSet(this, false, true)) {
            ((AbstractCursorAware)this.parent).closeCursor(this);
        }
    }

    static {
        try {
            CLOSED = MethodHandles.lookup().findVarHandle(AbstractCursor.class, "closed", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

